/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.accessory;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.pos.sdk.PosConstants;
import com.pos.sdk.PosLog;
import com.pos.sdk.accessory.IPosAccessory;
import com.pos.sdk.accessory.IPosAccessoryListener;
import com.pos.sdk.servicemanager.POIServiceManager;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosTlv;
import com.pos.sdk.utils.PosUtils;
import com.pos.sdk.utils.attack.AttackLog;
import com.pos.sdk.utils.attack.AttackUtil;
import com.pos.sdk.utils.attack.AttackValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class POIGeneralAPI {
    private static final String TAG = "POIGeneralAPI";
    private static final boolean DEBUG = PosConstants.DEBUG;
    public static final int LED_BLUE = 16;
    public static final int LED_GREEN = 32;
    public static final int LED_YELLOW = 64;
    public static final int LED_RED = 128;
    public static final int VERSION_TYPE_SP = 1;
    public static final int VERSION_TYPE_MP = 2;
    public static final int VERSION_TYPE_AP = 3;
    public static final int VERSION_TYPE_HW = 4;
    public static final int VERSION_TYPE_SDK = 5;
    public static final int VERSION_TYPE_PSN = 6;
    public static final int VERSION_TYPE_DSN = 7;
    public static final int VERSION_TYPE_DSN2 = 8;
    public static final int VERSION_TYPE_KERNEL = 9;
    public static final int VERSION_TYPE_FLASHID = 10;
    public static final int VERSION_TYPE_CUSTOMER_NAME = 11;
    public static final int VERSION_TYPE_CUSTOMER_SUBNAME = 12;
    public static final int VERSION_TYPE_EXTERNAL_BASE = 65280;
    public static final int VERSION_UART_LIBRARY = 13;
    public static final int VERSION_TYPE_IMEI1 = 14;
    public static final int VERSION_TYPE_IMEI2 = 15;
    public static final int PAYMENT_APPLICATION_SCENE_UNENCRYPTED = 0;
    public static final int PAYMENT_APPLICATION_SCENE_MAG_ENCRYPTED = 1;
    public static final int PAYMENT_APPLICATION_SCENE_ENCRYPTED = 2;
    public static final int RF_REGISTER_TYPE_A_OCCV = 49;
    public static final int RF_REGISTER_TYPE_M1_OCCV = 50;
    public static final int RF_REGISTER_TYPE_A_MICV = 51;
    public static final int RF_REGISTER_TYPE_B_MICV = 52;
    public static final int RF_REGISTER_TYPE_F_MICV = 53;
    public static final int RF_REGISTER_CACHE_BUF_SIZE = 54;
    public static final int RF_REGISTER_TYPE_A_SENSITIVITY = 55;
    public static final int RF_REGISTER_TYPE_B_SENSITIVITY = 56;
    public static final int RF_REGISTER_TYPE_F_SENSITIVITY = 57;
    public static final int RF_REGISTER_TYPE_A_ANTENNA_GAIN = 58;
    public static final int RF_REGISTER_TYPE_B_ANTENNA_GAIN = 59;
    public static final int RF_REGISTER_TYPE_F_ANTENNA_GAIN = 60;
    public static final int RF_REGISTER_TYPE_A = 61;
    public static final int RF_REGISTER_TYPE_B = 62;
    public static final int RF_REGISTER_PERMIT_TYPE_FOR_DETECT = 63;
    public static final int RF_REGISTER_TYPE_F = 64;
    public static final int RF_REGISTER_TYPE_ISO15693 = 65;
    public static final int RF_REGISTER_TYPE_A_MODULATION_SOURCE = 74;
    public static final int RF_REGISTER_TYPE_B_MODULATION_SOURCE = 75;
    public static final int RF_REGISTER_TYPE_F_MODULATION_SOURCE = 76;
    public static final int RF_REGISTER_TYPE_A_MODULATION_TABLE = 77;
    public static final int RF_REGISTER_TYPE_B_MODULATION_TABLE = 78;
    public static final int RF_REGISTER_TYPE_F_MODULATION_TABLE = 79;
    public static final int RF_REGISTER_DIGITAL_TEST = 80;
    public static final int RF_REGISTER_CARRIER_ON = 81;
    public static final int RF_REGISTER_CARRIER_OFF = 82;
    public static final int RF_REGISTER_CARRIER_RESET = 83;
    public static final int RF_REGISTER_WUPA = 84;
    public static final int RF_REGISTER_WUPB = 85;
    public static final int RF_REGISTER_POLLING = 86;
    public static final int RF_REGISTER_ACTIVE = 87;
    public static final int RF_REGISTER_TRANSAC_A = 88;
    public static final int RF_REGISTER_TRANSAC_B = 89;
    public static final int RF_REGISTER_ADDR = 39;
    public static final int SYSTEM_INFO_TAG_BATTERY_VOLTAGE = 161;
    private static final int ACCESSORY_MSG_ONINFO = 1;
    private static final int ACCESSORY_MSG_ONERROR = 2;
    private static final int ACCESSORY_MSG_ONTRANSMIT_RAW_CMD_RET = 3;
    private static POIGeneralAPI mInstance = new POIGeneralAPI();
    private ArrayList<EventListener> mListeners = new ArrayList();
    private EventHandler mEventHandler;
    private AccessoryListener mAccessoryListener;

    private POIGeneralAPI() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mAccessoryListener = new AccessoryListener();
    }

    public static POIGeneralAPI getDefault() {
        return mInstance;
    }

    private IPosAccessory getService() {
        return IPosAccessory.Stub.asInterface(ServiceManager.getService((String)"com.pos.service.accessory"));
    }

    public void setDateTime(byte[] byArray) {
        try {
            this.getService().setDateTime(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public byte[] getDateTime() {
        try {
            return this.getService().getDateTime();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public String getSpVersion() {
        try {
            PosUtils.checkVersion(TAG);
            return this.getService().getSpVersion();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public String getApVersion() {
        try {
            return this.getService().getApVersion();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public String getSdkVersion() {
        try {
            return this.getService().getSdkVersion();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public String getVersion(int n) {
        try {
            return this.getService().getVersion(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public void setLed(int n, boolean bl) {
        try {
            this.getService().setLed(n, bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setLedFlash(int n, int n2, int n3) {
        try {
            this.getService().setLedFlash(n, n2, n3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setBeep(boolean bl, int n, int n2) {
        try {
            this.getService().setBeep(bl, n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setRFRegister(int n, int n2, int n3) {
        try {
            this.getService().setRFRegister(n, n2, n3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int getRFRegister(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().getRFRegister(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getAttackedLogs(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().getAttackedLogs(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public String getAttackedLogsList() {
        StringBuilder stringBuilder = new StringBuilder();
        PosByteArray posByteArray = new PosByteArray();
        int n = this.getAttackedLogs(null, posByteArray);
        if (n == 0) {
            stringBuilder.append("Read attack log success").append("\n");
            stringBuilder.append("AttackedLogs ").append(PosUtils.bytesToHexString(posByteArray.buffer)).append("\n").append("\n");
            List<AttackLog> list = AttackUtil.handleCommand(posByteArray.buffer);
            for (AttackLog attackLog : list) {
                stringBuilder.append(attackLog.getSrc()).append("\n");
                stringBuilder.append("Date : ").append(attackLog.getDate()).append("\n");
                stringBuilder.append("Attack Type : ").append(attackLog.getAttackType().name).append("\n");
                stringBuilder.append("Attack Value : ");
                if (attackLog.getAttackValue() != null) {
                    List<AttackValue> list2 = attackLog.getAttackValue();
                    for (int i = 0; i < list2.size(); ++i) {
                        stringBuilder.append(list2.get((int)i).name);
                        if (i >= list2.size() - 1) continue;
                        stringBuilder.append(" | ");
                    }
                }
                stringBuilder.append("\n").append("\n");
            }
            PosLog.e("com.xc.attacked", "AttackedLogs " + stringBuilder.toString());
        } else {
            stringBuilder.append("Read attack log failure").append("\n");
            stringBuilder.append("error code ").append(n).append("\n");
        }
        stringBuilder.append("SP version ").append(this.getSpVersion());
        return stringBuilder.toString();
    }

    public int switchI2CInteractive(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().switchI2CInteractive(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(boolean bl, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().transmitRawCmd(bl, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getRFRegisterValue(int n, int n2) {
        try {
            return this.getService().getRFRegisterValue(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setFactoryFlag(int n) {
        try {
            return this.getService().setFactoryFlag(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getFactoryFlag(int n) {
        try {
            return this.getService().getFactoryFlag(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int clearFactoryFlag(int n) {
        try {
            return this.getService().clearFactoryFlag(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setRFRegisterRaw(byte[] byArray) {
        try {
            return this.getService().setRFRegisterRaw(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setRFTempRegisterRaw(byte[] byArray) {
        try {
            return this.getService().setRFTempRegisterRaw(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getRFTempRegisterValueRaw(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().getRFTempRegisterValueRaw(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setParameters(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().setParameters(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setProperty(String string, String string2) {
        try {
            return this.getService().setProperty(string, string2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getSystemInfo(int n, PosByteArray posByteArray) {
        if (posByteArray == null) {
            PosLog.e(TAG, "getSystemInfo:: invalid parameters!");
            return -1;
        }
        PosByteArray posByteArray2 = new PosByteArray();
        int n2 = this.getSystemInfo(new byte[]{(byte)(n & 0xFF), 0}, posByteArray2);
        if (n2 == 0 && posByteArray2.buffer != null) {
            PosTlv posTlv = new PosTlv(posByteArray2.buffer);
            while (posTlv.isValidObject()) {
                if (posTlv.getTag() == n) {
                    byte[] byArray = posTlv.getData();
                    posByteArray.buffer = Arrays.copyOf(byArray, byArray.length);
                    posByteArray.len = byArray.length;
                    break;
                }
                posTlv.nextObject();
            }
        }
        return n2;
    }

    public int getSystemInfo(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().getSystemInfo(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setScannerLed(boolean bl) {
        try {
            return this.getService().setScannerLed(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int openCashbox() {
        try {
            return this.getService().openCashbox();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public String getSpVersionEx(int n) {
        try {
            return this.getService().getSpVersionEx(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int setParametersEx(int n, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().setParametersEx(n, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setScannerLed(int n, boolean bl) {
        byte[] byArray = PosTlv.constructTlvObject(143, new byte[]{1, (byte)(bl ? 1 : 0)});
        return this.setParametersEx(n, byArray, null);
    }

    public int openCashbox(int n) {
        int n2 = -1;
        byte[] byArray = PosTlv.constructTlvObject(143, new byte[]{0, 0});
        n2 = this.setParametersEx(n, byArray, null);
        if (n2 == 0) {
            PosUtils.delayms(500);
            byArray = PosTlv.constructTlvObject(143, new byte[]{0, 1});
            n2 = this.setParametersEx(n, byArray, null);
        }
        return n2;
    }

    public int transmitRawCmdEx(int n, boolean bl, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().transmitRawCmdEx(n, bl, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setRFTempRegister(int n, int n2, int n3) {
        int n4 = -1;
        try {
            byte[] byArray = n == 61 || n == 62 ? PosTlv.constructTlvObject(n, (short)(n2 << 8 | n3)) : (n != 54 && n >= 49 && n <= 60 ? PosTlv.constructTlvObject(n, (byte)n3) : PosTlv.constructTlvObject(n, n3));
            n4 = this.setRFTempRegisterRaw(byArray);
            if (n4 != 0) {
                PosLog.e(TAG, "setRFRegister:: failed!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n4;
    }

    public int getRFTempRegisterValue(int n, int n2) {
        int n3 = -1;
        PosByteArray posByteArray = new PosByteArray();
        try {
            n3 = this.getService().getRFTempRegisterValueRaw(null, posByteArray);
            if (n3 == 0) {
                PosTlv posTlv = new PosTlv(posByteArray.buffer);
                while (posTlv.isValidObject()) {
                    if (posTlv.getTag() == n) {
                        byte[] byArray = posTlv.getData();
                        switch (n) {
                            case 61: 
                            case 62: {
                                for (int i = 0; i < byArray.length; i += 2) {
                                    if ((byArray[i] & 0xFF) != n2) continue;
                                    n3 = byArray[i + 1] & 0xFF;
                                    return n3;
                                }
                                break;
                            }
                            default: {
                                switch (byArray.length) {
                                    case 1: {
                                        return byArray[0] & 0xFF;
                                    }
                                    case 2: {
                                        return PosUtils.bytesToShortBe(byArray);
                                    }
                                    case 4: {
                                        return PosUtils.bytesToIntBe(byArray);
                                    }
                                }
                                PosLog.e(TAG, "getRFTempRegisterValue:: Parse value length error, len= " + byArray.length);
                            }
                        }
                    }
                    posTlv.nextObject();
                }
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n3;
    }

    public int getAntennaPerformance(PosByteArray posByteArray) {
        try {
            return this.getService().getAntennaPerformance(posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setSpCmdTimeout(long l) {
        return this.setSpCmdTimeout(POIServiceManager.getDefault().getNumberOfSp() - 1, l);
    }

    public int setSpCmdTimeout(int n, long l) {
        try {
            return this.getService().setSpCmdTimeout(n, l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setApplicationScene(int n) {
        try {
            return this.getService().setApplicationScene(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getCurrentApplicationScene() {
        try {
            return this.getService().getCurrentApplicationScene();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public byte[] getCertificate() {
        try {
            return this.getService().getCertificate();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int setCertificate(byte[] byArray) {
        try {
            return this.getService().setCertificate(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setSpSleep() {
        try {
            return this.getService().setSpSleep();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int deleteCertificate() {
        try {
            return this.getService().deleteCertificate();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public void setSlotLight(boolean bl) {
        try {
            this.getService().setSlotLight(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int setSpSleepTime(int n) {
        try {
            return this.getService().setSpSleepTime(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public void setKeyboardLight(boolean bl) {
        try {
            this.getService().setKeyboardLight(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int setPrintMode(int n) {
        try {
            return this.getService().setPrintMode(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getPrintMode(PosByteArray posByteArray) {
        try {
            return this.getService().getPrintMode(posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setPrintKeepHighConcentration(boolean bl) {
        try {
            return this.getService().setPrintKeepHighConcentration(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getPrintKeepHighConcentration(PosByteArray posByteArray) {
        try {
            return this.getService().getPrintKeepHighConcentration(posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedSetPinResultType(int n) {
        try {
            return this.getService().PedSetPinResultType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(EventListener eventListener) {
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (DEBUG) {
                PosLog.d(TAG, "registerListener listener= " + eventListener);
            }
            if (eventListener != null && !this.mListeners.contains(eventListener)) {
                if (!POIServiceManager.getDefault().isSupportMultiUsersCallback()) {
                    this.mListeners.clear();
                }
                this.mListeners.add(eventListener);
                if (this.mListeners.size() == 1) {
                    try {
                        this.getService().registerListener(this.mAccessoryListener);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(EventListener eventListener) {
        if (DEBUG) {
            PosLog.d(TAG, "unregisterListener listener= " + eventListener);
        }
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(eventListener);
            if (this.mListeners.size() == 0) {
                try {
                    this.getService().unregisterListener(this.mAccessoryListener);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    private class AccessoryListener
    extends IPosAccessoryListener.Stub {
        private AccessoryListener() {
        }

        @Override
        public void onInfo(int n, int n2) {
            if (POIGeneralAPI.this.mEventHandler != null) {
                POIGeneralAPI.this.mEventHandler.sendMessage(POIGeneralAPI.this.mEventHandler.obtainMessage(1, n, n2));
            }
        }

        @Override
        public void onError(int n, int n2) {
            if (POIGeneralAPI.this.mEventHandler != null) {
                POIGeneralAPI.this.mEventHandler.sendMessage(POIGeneralAPI.this.mEventHandler.obtainMessage(2, n, n2));
            }
        }

        @Override
        public void onTransmitRawCmdRet(byte[] byArray) {
            if (POIGeneralAPI.this.mEventHandler != null) {
                POIGeneralAPI.this.mEventHandler.sendMessage(POIGeneralAPI.this.mEventHandler.obtainMessage(3, byArray));
            }
        }
    }

    private class EventHandler
    extends Handler {
        private POIGeneralAPI mAccessoryManager;

        public EventHandler(POIGeneralAPI pOIGeneralAPI2, Looper looper) {
            super(looper);
            this.mAccessoryManager = pOIGeneralAPI2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    ArrayList arrayList = POIGeneralAPI.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIGeneralAPI.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIGeneralAPI.TAG, "onInfo listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onInfo(this.mAccessoryManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIGeneralAPI.TAG, "Listener for onInfo failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 2: {
                    ArrayList arrayList = POIGeneralAPI.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIGeneralAPI.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIGeneralAPI.TAG, "onError listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onError(this.mAccessoryManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIGeneralAPI.TAG, "Listener for onError failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 3: {
                    ArrayList arrayList = POIGeneralAPI.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIGeneralAPI.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIGeneralAPI.TAG, "onTransmitRawCmdRet listener= " + eventListener);
                                }
                                eventListener.onTransmitRawCmdRet(this.mAccessoryManager, (byte[])message.obj);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIGeneralAPI.TAG, "Listener for onTransmitRawCmdRet failed", exception);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface EventListener {
        public void onInfo(POIGeneralAPI var1, int var2, int var3);

        public void onError(POIGeneralAPI var1, int var2, int var3);

        public void onTransmitRawCmdRet(POIGeneralAPI var1, byte[] var2);
    }
}

