/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.accessory;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.pos.sdk.PosConstants;
import com.pos.sdk.PosLog;
import com.pos.sdk.accessory.IPosSPUpdate;
import com.pos.sdk.accessory.IPosSPUpdateListener;
import com.pos.sdk.servicemanager.POIServiceManager;
import java.util.ArrayList;

public class POISpUpdateManager {
    private static final String TAG = "POISpUpdateManager";
    private static final boolean DEBUG = PosConstants.DEBUG;
    private static final int UPDATE_MSG_ONSUCCESS = 1;
    private static final int UPDATE_MSG_ONERROR = 2;
    private static final int UPDATE_MSG_ONPROGRESS_UPDATE = 3;
    private static POISpUpdateManager mInstance = new POISpUpdateManager();
    private ArrayList<EventListener> mListeners = new ArrayList();
    private EventHandler mEventHandler;
    private PosSPUpdateListener mSPUpdateListener;

    private POISpUpdateManager() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mSPUpdateListener = new PosSPUpdateListener();
    }

    public static POISpUpdateManager getDefault() {
        return mInstance;
    }

    private IPosSPUpdate getService() {
        return IPosSPUpdate.Stub.asInterface(ServiceManager.getService((String)"com.pos.service.spupdate"));
    }

    public void setUpdateMode(int n) {
        try {
            this.getService().setUpdateMode(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setNeedToVerify(int n) {
        try {
            this.getService().setNeedToVerify(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setReboot(int n) {
        try {
            this.getService().setReboot(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void updateSpFirmware(String string) {
        try {
            this.getService().updateSpFirmware(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(EventListener eventListener) {
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (DEBUG) {
                PosLog.d(TAG, "registerListener listener= " + eventListener);
            }
            if (eventListener != null && !this.mListeners.contains(eventListener)) {
                if (!POIServiceManager.getDefault().isSupportMultiUsersCallback()) {
                    this.mListeners.clear();
                }
                this.mListeners.add(eventListener);
                if (this.mListeners.size() == 1) {
                    try {
                        this.getService().registerListener(this.mSPUpdateListener);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(EventListener eventListener) {
        if (DEBUG) {
            PosLog.d(TAG, "unregisterListener listener= " + eventListener);
        }
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(eventListener);
            if (this.mListeners.size() == 0) {
                try {
                    this.getService().unregisterListener(this.mSPUpdateListener);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    private class PosSPUpdateListener
    extends IPosSPUpdateListener.Stub {
        private PosSPUpdateListener() {
        }

        @Override
        public void onError(int n, int n2) {
            if (POISpUpdateManager.this.mEventHandler != null) {
                POISpUpdateManager.this.mEventHandler.sendMessage(POISpUpdateManager.this.mEventHandler.obtainMessage(2, n, n2));
            }
        }

        @Override
        public void onProgressUpdate(String string) throws RemoteException {
            if (POISpUpdateManager.this.mEventHandler != null) {
                Message message = new Message();
                message.what = 3;
                message.obj = string;
                POISpUpdateManager.this.mEventHandler.sendMessage(message);
            }
        }

        @Override
        public void onSuccess(int n, int n2) throws RemoteException {
            if (POISpUpdateManager.this.mEventHandler != null) {
                POISpUpdateManager.this.mEventHandler.sendMessage(POISpUpdateManager.this.mEventHandler.obtainMessage(1, n, n2));
            }
        }
    }

    private class EventHandler
    extends Handler {
        private POISpUpdateManager mAccessoryManager;

        public EventHandler(POISpUpdateManager pOISpUpdateManager2, Looper looper) {
            super(looper);
            this.mAccessoryManager = pOISpUpdateManager2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    ArrayList arrayList = POISpUpdateManager.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POISpUpdateManager.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POISpUpdateManager.TAG, "onInfo listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onSuccess(this.mAccessoryManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POISpUpdateManager.TAG, "Listener for onInfo failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 2: {
                    ArrayList arrayList = POISpUpdateManager.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POISpUpdateManager.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POISpUpdateManager.TAG, "onError listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onError(this.mAccessoryManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POISpUpdateManager.TAG, "Listener for onError failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 3: {
                    ArrayList arrayList = POISpUpdateManager.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POISpUpdateManager.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POISpUpdateManager.TAG, "onTransmitRawCmdRet listener= " + eventListener);
                                }
                                eventListener.onProgressUpdate(this.mAccessoryManager, (String)message.obj);
                            }
                            catch (Exception exception) {
                                PosLog.e(POISpUpdateManager.TAG, "Listener for onTransmitRawCmdRet failed", exception);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface EventListener {
        public void onSuccess(POISpUpdateManager var1, int var2, int var3);

        public void onError(POISpUpdateManager var1, int var2, int var3);

        public void onProgressUpdate(POISpUpdateManager var1, String var2);
    }
}

