/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.pos.sdk.PosConstants;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosCardReaderListener;
import com.pos.sdk.cardreader.IPosCardReaderService;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.cardreader.PosFelicaCardReader;
import com.pos.sdk.cardreader.PosIccCardReader;
import com.pos.sdk.cardreader.PosMagCardReader;
import com.pos.sdk.cardreader.PosMemoryCardReader;
import com.pos.sdk.cardreader.PosMifareCardReader;
import com.pos.sdk.cardreader.PosPiccCardReader;
import com.pos.sdk.cardreader.PosPsamCardReader;
import com.pos.sdk.cardreader.PosSidCardReader;
import com.pos.sdk.cardreader.PosViccCardReader;
import com.pos.sdk.utils.PosUtils;
import java.util.ArrayList;

public class POICardManager {
    private static final String TAG = "PosCardReaderManager";
    private static final boolean DEBUG = PosConstants.DEBUG;
    public static final int CARDREADER_TYPE_UNKNOW = 0;
    public static final int CARDREADER_TYPE_PSAM = 1;
    public static final int CARDREADER_TYPE_ICC = 2;
    public static final int CARDREADER_TYPE_MEMORY = 4;
    public static final int CARDREADER_TYPE_PICC = 8;
    public static final int CARDREADER_TYPE_MIFARE = 16;
    public static final int CARDREADER_TYPE_VICC = 32;
    public static final int CARDREADER_TYPE_SID = 64;
    public static final int CARDREADER_TYPE_MAG = 128;
    public static final int CARDREADER_TYPE_FELICA = 256;
    public static final int CARDREADER_BAUDRATE_9600 = 17;
    public static final int CARDREADER_BAUDRATE_19200 = 18;
    public static final int CARDREADER_BAUDRATE_38400 = 19;
    public static final int CARDREADER_VOLTAGE_50V = 0;
    public static final int CARDREADER_VOLTAGE_18V = 1;
    public static final int CARDREADER_VOLTAGE_33V = 2;
    public static final int CARDREADER_TLV_TAG_BAUDRATE = 65;
    public static final int CARDREADER_TLV_TAG_VOLTAGE = 66;
    public static final int CARDREADER_TLV_TAG_WTX = 67;
    public static final int CARDREADER_APDU_GET_RSP_TYPE_MANUAL = 0;
    public static final int CARDREADER_APDU_GET_RSP_TYPE_AUTO = 1;
    public static final int CARDREADER_APDU_GET_RSP_TYPE_MANUAL_BY_SDK = 2;
    public static final int CARDREADER_PICC_REMOVE_MODE_HALT = 72;
    public static final int CARDREADER_PICC_REMOVE_MODE_REMOVE = 82;
    public static final int CARDREADER_PICC_REMOVE_MODE_EMV = 69;
    public static final int CARDREADER_PICC_REMOVE_MODE_STOP = 83;
    public static final int CARDREADER_PICC_CARD_TYPE_A = 1;
    public static final int CARDREADER_PICC_CARD_TYPE_B = 2;
    public static final int CARDREADER_PICC_CARD_TYPE_FELICA = 3;
    public static final int CARDREADER_PICC_CARD_TYPE_MIFARE = 4;
    public static final int CARDREADER_PICC_CARD_TYPE_VICC = 5;
    public static final int CARDREADER_PICC_RATE_106K = 106000;
    public static final int CARDREADER_PICC_RATE_212K = 212000;
    public static final int CARDREADER_PICC_RATE_424K = 424000;
    public static final int CARDREADER_PICC_RATE_848K = 848000;
    public static final int CARDREADER_PICC_FRAME_MODE_SHORT = 7;
    public static final int CARDREADER_PICC_FRAME_MODE_NORMAL = 9;
    private static final int CARDREADER_MSG_ONCARDINFO = 1;
    private static POICardManager mInstance;
    private PosPsamCardReader mPsamCardReader;
    private PosIccCardReader mIccCardReader;
    private PosMemoryCardReader mMemoryCardReader;
    private PosPiccCardReader mPiccCardReader;
    private PosMifareCardReader mMifareCardReader;
    private PosViccCardReader mViccCardReader;
    private PosSidCardReader mSidCardReader;
    private PosMagCardReader mMagCardReader;
    private PosFelicaCardReader mFelicaCardReader;
    private EventHandler mEventHandler;
    private ArrayList<EventListener> mListeners;
    private CardReaderListener mCardReaderListener;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (DEBUG) {
                PosLog.d(POICardManager.TAG, "onReceive:: action= " + string);
            }
            if (string.equals("com.pos.action.RECONNECT_POS_SERVICE")) {
                POICardManager.this.resetCardReader();
            }
        }
    };

    private POICardManager(Context context) {
        this.resetCardReader();
        this.mListeners = new ArrayList();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mCardReaderListener = new CardReaderListener();
        context.registerReceiver(this.mReceiver, new IntentFilter("com.pos.action.RECONNECT_POS_SERVICE"));
        PosUtils.checkVersion(TAG);
    }

    public static synchronized POICardManager getDefault(Context context) {
        if (mInstance == null) {
            mInstance = new POICardManager(context);
        }
        return mInstance;
    }

    public int getSupportTypes() {
        try {
            return this.getService().getSupportTypes();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public synchronized PosPsamCardReader getPsamCardReader() {
        if (this.mPsamCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(1);
            if (iBinder != null) {
                this.mPsamCardReader = new PosPsamCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getPsamCardReader failed!");
            }
        }
        return this.mPsamCardReader;
    }

    public synchronized PosIccCardReader getIccCardReader() {
        if (this.mIccCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(2);
            if (iBinder != null) {
                this.mIccCardReader = new PosIccCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getIccCardReader failed!");
            }
        }
        return this.mIccCardReader;
    }

    public synchronized PosMemoryCardReader getMemoryCardReader() {
        if (this.mMemoryCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(4);
            if (iBinder != null) {
                this.mMemoryCardReader = new PosMemoryCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getMemoryCardReader failed!");
            }
        }
        return this.mMemoryCardReader;
    }

    public synchronized PosPiccCardReader getPiccCardReader() {
        if (this.mPiccCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(8);
            if (iBinder != null) {
                this.mPiccCardReader = new PosPiccCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getPiccCardReader failed!");
            }
        }
        return this.mPiccCardReader;
    }

    public synchronized PosMifareCardReader getMifareCardReader() {
        if (this.mMifareCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(16);
            if (iBinder != null) {
                this.mMifareCardReader = new PosMifareCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getMifareCardReader failed!");
            }
        }
        return this.mMifareCardReader;
    }

    public synchronized PosViccCardReader getViccCardReader() {
        if (this.mViccCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(32);
            if (iBinder != null) {
                this.mViccCardReader = new PosViccCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getViccCardReader failed!");
            }
        }
        return this.mViccCardReader;
    }

    public synchronized PosSidCardReader getSidCardReader() {
        if (this.mSidCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(64);
            if (iBinder != null) {
                this.mSidCardReader = new PosSidCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getSidCardReader failed!");
            }
        }
        return this.mSidCardReader;
    }

    public synchronized PosMagCardReader getMagCardReader() {
        if (this.mMagCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(128);
            if (iBinder != null) {
                this.mMagCardReader = new PosMagCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getMagCardReader failed!");
            }
        }
        return this.mMagCardReader;
    }

    public synchronized PosFelicaCardReader getFelicaCardReader() {
        if (this.mFelicaCardReader == null) {
            IBinder iBinder = this.getCardReaderByType(256);
            if (iBinder != null) {
                this.mFelicaCardReader = new PosFelicaCardReader(iBinder);
            } else {
                PosLog.e(TAG, "getFelicaCardReader failed!");
            }
        }
        return this.mFelicaCardReader;
    }

    private IPosCardReaderService getService() {
        return IPosCardReaderService.Stub.asInterface(ServiceManager.getService((String)"com.pos.service.cardreader"));
    }

    private IBinder getCardReaderByType(int n) {
        try {
            return this.getService().getCardReaderByType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int getIcCount() {
        try {
            return this.getService().getIcCount();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public int getPiccCount() {
        try {
            return this.getService().getPiccCount();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public int getMagCount() {
        try {
            return this.getService().getMagCount();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    private void resetCardReader() {
        this.mPsamCardReader = null;
        this.mIccCardReader = null;
        this.mMemoryCardReader = null;
        this.mPiccCardReader = null;
        this.mMifareCardReader = null;
        this.mViccCardReader = null;
        this.mSidCardReader = null;
        this.mMagCardReader = null;
        this.mFelicaCardReader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCardReaderListener(EventListener eventListener) {
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (DEBUG) {
                PosLog.d(TAG, "registerCardReaderListener listener= " + eventListener);
            }
            if (eventListener != null && !this.mListeners.contains(eventListener)) {
                this.mListeners.add(eventListener);
                if (this.mListeners.size() == 1) {
                    try {
                        this.getService().registerCardReaderListener(this.mCardReaderListener);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCardReaderListener(EventListener eventListener) {
        if (DEBUG) {
            PosLog.d(TAG, "unregisterCardReaderListener listener= " + eventListener);
        }
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(eventListener);
        }
    }

    private class CardReaderListener
    extends IPosCardReaderListener.Stub {
        private CardReaderListener() {
        }

        @Override
        public void onCardInfo(PosCardReaderInfo posCardReaderInfo) {
            if (POICardManager.this.mEventHandler != null) {
                POICardManager.this.mEventHandler.sendMessage(POICardManager.this.mEventHandler.obtainMessage(1, 0, 0, posCardReaderInfo));
            }
        }
    }

    private class EventHandler
    extends Handler {
        private POICardManager mCardManager;

        public EventHandler(POICardManager pOICardManager2, Looper looper) {
            super(looper);
            this.mCardManager = pOICardManager2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    ArrayList arrayList = POICardManager.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POICardManager.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POICardManager.TAG, "onInfo listener= " + eventListener + ", msg.obj= " + (PosCardReaderInfo)message.obj);
                                }
                                eventListener.onCardInfo(this.mCardManager, (PosCardReaderInfo)message.obj);
                            }
                            catch (Exception exception) {
                                PosLog.e(POICardManager.TAG, "Listener for onCardInfo failed", exception);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface EventListener {
        public void onCardInfo(POICardManager var1, PosCardReaderInfo var2);
    }
}

