/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Parcel;
import android.os.Parcelable;
import com.pos.sdk.utils.PosUtils;
import java.util.Arrays;

public class PosCardReaderInfo
implements Parcelable {
    public int mCategory;
    public int mCardType;
    public int mCardChannel;
    public byte[] mSerialNum;
    public byte[] mAttribute;
    public static final Parcelable.Creator<PosCardReaderInfo> CREATOR = new Parcelable.Creator<PosCardReaderInfo>(){

        public PosCardReaderInfo createFromParcel(Parcel parcel) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            byArray = parcel.createByteArray();
            byArray2 = parcel.createByteArray();
            return new PosCardReaderInfo(n, n2, n3, byArray, byArray2);
        }

        public PosCardReaderInfo[] newArray(int n) {
            return new PosCardReaderInfo[n];
        }
    };

    public PosCardReaderInfo() {
        this.mCategory = 0;
        this.mCardType = 0;
        this.mCardChannel = 0;
        this.mSerialNum = null;
        this.mAttribute = null;
    }

    public PosCardReaderInfo(int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        this.mCategory = n;
        this.mCardType = n2;
        this.mCardChannel = n3;
        this.mSerialNum = byArray;
        this.mAttribute = byArray2;
    }

    public PosCardReaderInfo(PosCardReaderInfo posCardReaderInfo) {
        this.mCategory = posCardReaderInfo.mCategory;
        this.mCardType = posCardReaderInfo.mCardType;
        this.mCardChannel = posCardReaderInfo.mCardChannel;
        if (posCardReaderInfo.mSerialNum != null) {
            this.mSerialNum = Arrays.copyOf(posCardReaderInfo.mSerialNum, posCardReaderInfo.mSerialNum.length);
        }
        if (posCardReaderInfo.mAttribute != null) {
            this.mAttribute = Arrays.copyOf(posCardReaderInfo.mAttribute, posCardReaderInfo.mAttribute.length);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mCategory);
        parcel.writeInt(this.mCardType);
        parcel.writeInt(this.mCardChannel);
        parcel.writeByteArray(this.mSerialNum);
        parcel.writeByteArray(this.mAttribute);
    }

    public void readFromParcel(Parcel parcel) {
        this.mCategory = parcel.readInt();
        this.mCardType = parcel.readInt();
        this.mCardChannel = parcel.readInt();
        this.mSerialNum = parcel.createByteArray();
        this.mAttribute = parcel.createByteArray();
    }

    public void copyFrom(PosCardReaderInfo posCardReaderInfo) {
        this.mCategory = posCardReaderInfo.mCategory;
        this.mCardType = posCardReaderInfo.mCardType;
        this.mCardChannel = posCardReaderInfo.mCardChannel;
        if (posCardReaderInfo.mSerialNum != null) {
            this.mSerialNum = Arrays.copyOf(posCardReaderInfo.mSerialNum, posCardReaderInfo.mSerialNum.length);
        }
        if (posCardReaderInfo.mAttribute != null) {
            this.mAttribute = Arrays.copyOf(posCardReaderInfo.mAttribute, posCardReaderInfo.mAttribute.length);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PosCardReaderInfo:");
        stringBuilder.append("mCategory= " + this.mCategory + ", ");
        stringBuilder.append("mCardType= " + this.mCardType + ", ");
        stringBuilder.append("mCardChannel= " + this.mCardChannel + ", ");
        stringBuilder.append("mSerialNum= " + PosUtils.bytesToHexString(this.mSerialNum) + ", ");
        stringBuilder.append("mAttribute= " + PosUtils.bytesToHexString(this.mAttribute));
        return stringBuilder.toString();
    }
}

