/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosFelicaCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosParameters;
import java.util.ArrayList;
import java.util.List;

public class PosFelicaCardReader {
    private static final String TAG = "PosFelicaCardReader";
    public static final int FELICA_CODE_SIZE = 1;
    public static final int FELICA_SYS_CODE_SIZE = 2;
    public static final int FELICA_ID_SIZE = 8;
    public static final int FELICA_PM_SIZE = 8;
    public static final int FELICA_REQ_DATA_SIZE = 2;
    public static final int FELICA_CNT_SIZE = 1;
    public static final int FELICA_SFLAG_SIZE = 1;
    public static final int FELICA_NODE_SIZE = 2;
    public static final int FELICA_BLKN_SIZE_S = 2;
    public static final int FELICA_BLKN_SIZE_L = 3;
    public static final int FELICA_BLOCK_SIZE = 16;
    private IPosFelicaCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosFelicaCardReader(IBinder iBinder) {
        this.mCardReader = IPosFelicaCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.open(this.mCb);
            this.mDeviceOpened = n == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int setParameters(Parameters parameters) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setParameters:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.setParameters(parameters.flatten());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public Parameters getParameters() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getParameters:: device is not opened!");
            return null;
        }
        try {
            Parameters parameters = new Parameters();
            String string = this.mCardReader.getParameters();
            parameters.unflatten(string);
            return parameters;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int detect() {
        return this.detect(0);
    }

    public int detect(int n) {
        return this.detect(new byte[]{-1, -1}, 1, n);
    }

    public int detect(byte[] byArray, int n, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect(byArray, n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int requestService(byte[] byArray, List<byte[]> list, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "requestService:: device is not opened!");
            return -1;
        }
        try {
            ArrayList<PosByteArray> arrayList = new ArrayList<PosByteArray>();
            for (byte[] byArray2 : list) {
                arrayList.add(new PosByteArray(byArray2, byArray2.length));
            }
            return this.mCardReader.requestService(byArray, arrayList, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int readNoSecure(byte[] byArray, List<byte[]> list, List<byte[]> list2, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "readNoSecure:: device is not opened!");
            return -1;
        }
        try {
            ArrayList<PosByteArray> arrayList = new ArrayList<PosByteArray>();
            for (byte[] object2 : list) {
                arrayList.add(new PosByteArray(object2, object2.length));
            }
            ArrayList arrayList2 = new ArrayList();
            for (byte[] byArray2 : list2) {
                arrayList2.add(new PosByteArray(byArray2, byArray2.length));
            }
            return this.mCardReader.readNoSecure(byArray, arrayList, arrayList2, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int writeNoSecure(byte[] byArray, List<byte[]> list, List<byte[]> list2, List<byte[]> list3, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "writeNoSecure:: device is not opened!");
            return -1;
        }
        try {
            Object object2;
            ArrayList<PosByteArray> arrayList = new ArrayList<PosByteArray>();
            for (byte[] object22 : list) {
                arrayList.add(new PosByteArray(object22, object22.length));
            }
            ArrayList arrayList2 = new ArrayList();
            for (Object object2 : list2) {
                arrayList2.add(new PosByteArray((byte[])object2, ((Object)object2).length));
            }
            ArrayList<PosByteArray> arrayList3 = new ArrayList<PosByteArray>();
            object2 = list3.iterator();
            while (object2.hasNext()) {
                byte[] byArray2 = (byte[])object2.next();
                arrayList3.add(new PosByteArray(byArray2, byArray2.length));
            }
            return this.mCardReader.writeNoSecure(byArray, arrayList, arrayList2, arrayList3, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitCmd(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitRawCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitRawCmd(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int removeCard() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "removeCard:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.removeCard();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public static class Parameters
    extends PosParameters {
        public static final String KEY_TYPE = "felica-type";
        public static final String KEY_READER_RATE = "felica-reader-rate";
        public static final String KEY_CARD_RATE = "felica-card-rate";
        public static final String KEY_FRAME_MODE = "felica-frame-mode";
        public static final String KEY_FRAME_WAIT_TIME = "felica-frame-wait-time";
        public static final String KEY_FRAME_GUARD_TIME = "felica-frame-guard-time";
        public static final String KEY_FRAME_SIZE = "felica-frame-size";
        public static final String KEY_CRC_ENABLE = "felica-crc-enable";

        public void setType(int n) {
            this.set(KEY_TYPE, n);
        }

        public int getType() {
            return this.getInt(KEY_TYPE);
        }

        public void setReaderRate(int n) {
            this.set(KEY_READER_RATE, n);
        }

        public int getReaderRate() {
            return this.getInt(KEY_READER_RATE);
        }

        public void setCardRate(int n) {
            this.set(KEY_CARD_RATE, n);
        }

        public int getCardRate() {
            return this.getInt(KEY_CARD_RATE);
        }

        public void setFrameMode(int n) {
            this.set(KEY_FRAME_MODE, n);
        }

        public int getFrameMode() {
            return this.getInt(KEY_FRAME_MODE);
        }

        public void setFrameWaitTime(int n) {
            this.set(KEY_FRAME_WAIT_TIME, n);
        }

        public int getFrameWaitTime() {
            return this.getInt(KEY_FRAME_WAIT_TIME);
        }

        public void setFrameGuardTime(int n) {
            this.set(KEY_FRAME_GUARD_TIME, n);
        }

        public int getFrameGuardTime() {
            return this.getInt(KEY_FRAME_GUARD_TIME);
        }

        public void setFrameSize(int n) {
            this.set(KEY_FRAME_SIZE, n);
        }

        public int getFrameSize() {
            return this.getInt(KEY_FRAME_SIZE);
        }

        public void setCrcEnable(boolean bl) {
            this.set(KEY_CRC_ENABLE, bl);
        }

        public boolean getCrcEnable() {
            return this.getBoolean(KEY_CRC_ENABLE);
        }
    }
}

