/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosIccCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosTlv;

public class PosIccCardReader {
    private static final String TAG = "PosIccCardReader";
    private IPosIccCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosIccCardReader(IBinder iBinder) {
        this.mCardReader = IPosIccCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        return this.open(new byte[]{0});
    }

    public int open(int n) {
        if (!PosIccCardReader.isValidBaudrate(n)) {
            PosLog.e(TAG, "open:: invalid parameters: baudrate= " + n);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(65, (byte)(n & 0xFF));
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return this.open(byArray2);
    }

    public int open(int n, int n2) {
        if (!PosIccCardReader.isValidBaudrate(n) || !PosIccCardReader.isValidPowerVol(n2)) {
            PosLog.e(TAG, "open:: invalid parameters: baudrate= " + n + ", voltage= " + n2);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(65, (byte)(n & 0xFF));
        byte[] byArray2 = PosTlv.constructTlvObject(66, (byte)(n2 & 0xFF));
        byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
        byArray3[0] = 0;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
        return this.open(byArray3);
    }

    public int openWithPowerVol(int n) {
        if (!PosIccCardReader.isValidPowerVol(n)) {
            PosLog.e(TAG, "openWithPowerVol:: invalid parameters: voltage= " + n);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(66, (byte)(n & 0xFF));
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return this.open(byArray2);
    }

    public int open(byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.open(byArray, this.mCb);
            this.mDeviceOpened = n == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int detect() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int reset() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "reset:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.reset();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public void setTransmitApduTimeout(long l) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setTransmitApduTimeout:: device is not opened!");
            return;
        }
        try {
            this.mCardReader.setTransmitApduTimeout(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setTransmitApduGetRspType(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setTransmitApduGetRspType:: device is not opened!");
            return;
        }
        try {
            this.mCardReader.setTransmitApduGetRspType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int transmitApdu(byte[] byArray, PosByteArray posByteArray, PosByteArray posByteArray2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitApdu:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitApdu(byArray, posByteArray, posByteArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int setBaudrate(int n) {
        if (!PosIccCardReader.isValidBaudrate(n)) {
            PosLog.e(TAG, "setBaudrate:: invalid parameters: voltage= " + n);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(65, (byte)(n & 0xFF));
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return this.setParameters(byArray2);
    }

    public int setPowerVol(int n) {
        if (!PosIccCardReader.isValidPowerVol(n)) {
            PosLog.e(TAG, "setPowerVol:: invalid parameters: voltage= " + n);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(66, (byte)(n & 0xFF));
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return this.setParameters(byArray2);
    }

    public int setParameters(byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setParameters:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.setParameters(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    private static boolean isValidBaudrate(int n) {
        switch (n) {
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidPowerVol(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

