/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosMagCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;

public class PosMagCardReader {
    private static final String TAG = "PosMagCardReader";
    public static final int CARDREADER_DATA_TYPE_PLAIN = 1;
    public static final int CARDREADER_DATA_TYPE_ENCRYPT = 2;
    public static final int CARDREADER_DATA_TYPE_ENCRYPT_ZIOSK = 3;
    public static final int CARDREADER_DATA_TYPE_ENCRYPT_TRANSARMOR = 4;
    public static final int CARDREADER_KEY_TYPE_TDK = 1;
    public static final int CARDREADER_KEY_TYPE_DUKPT_MAC = 2;
    public static final int CARDREADER_KEY_TYPE_DUKPT_DATA_REQUEST = 3;
    public static final int CARDREADER_KEY_TYPE_DUKPT_DATA_RESPONSE = 4;
    public static final int CARDREADER_KEY_TYPE_DUKPT_PIN = 5;
    public static final int CARDREADER_MODE_ECB = 1;
    public static final int CARDREADER_MODE_CBC = 2;
    public static final int CARDREADER_TRACE_INDEX_0 = 0;
    public static final int CARDREADER_TRACE_INDEX_1 = 1;
    public static final int CARDREADER_TRACE_INDEX_2 = 2;
    public static final int CARDREADER_TRACE_INDEX_3 = 3;
    private IPosMagCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosMagCardReader(IBinder iBinder) {
        this.mCardReader = IPosMagCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        return this.open(1, -1, -1, -1, (byte)48, null);
    }

    public int open(int n, int n2, int n3, byte by, byte[] byArray) {
        return this.open(2, n, n2, n3, by, byArray);
    }

    public int open(int n, int n2, int n3, int n4, byte by, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n5 = -1;
        try {
            n5 = this.mCardReader.open(n, n2, n3, n4, by, byArray, this.mCb);
            this.mDeviceOpened = n5 == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n5;
    }

    public int detect() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public byte[] getTraceData(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getTraceData:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getTraceData(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public byte[] getTraceDataKsn(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getTraceDataKsn:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getTraceDataKsn(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public byte[] getTraceMaskData(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getTraceMaskData:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getTraceMaskData(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }
}

