/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosMemoryCardReaderImpl;
import com.pos.sdk.utils.PosByteArray;

public class PosMemoryCardReader {
    private static final String TAG = "PosMemoryCardReader";
    public static final int MEMORY_CARD_TYPE_UNKNOW = 0;
    public static final int MEMORY_CARD_TYPE_AT88SC101 = 1;
    public static final int MEMORY_CARD_TYPE_AT88SC102 = 2;
    public static final int MEMORY_CARD_TYPE_AT88SC1604 = 3;
    public static final int MEMORY_CARD_TYPE_AT88SC153 = 4;
    public static final int MEMORY_CARD_TYPE_AT88SC1608 = 5;
    public static final int MEMORY_CARD_TYPE_SLE4428 = 6;
    public static final int MEMORY_CARD_TYPE_SLE4442 = 7;
    public static final int MEMORY_CARD_TYPE_AT24C01 = 16;
    public static final int MEMORY_CARD_TYPE_AT24C02 = 17;
    public static final int MEMORY_CARD_TYPE_AT24C04 = 18;
    public static final int MEMORY_CARD_TYPE_AT24C08 = 19;
    public static final int MEMORY_CARD_TYPE_AT24C16 = 20;
    public static final int MEMORY_CARD_TYPE_AT24C32 = 21;
    public static final int MEMORY_CARD_TYPE_AT24C64 = 22;
    public static final int MEMORY_CARD_TYPE_AT24C128 = 23;
    public static final int MEMORY_CARD_TYPE_AT24C256 = 24;
    public static final int MEMORY_CARD_TYPE_AT24C512 = 25;
    public static final int SLE4442_ZONE_TYPE_MZ = 0;
    public static final int SLE4442_ZONE_TYPE_PZ = 1;
    public static final int SLE4442_ZONE_TYPE_SZ = 2;
    public static final int AT88SC101_ZONE_TYPE_FZ = 0;
    public static final int AT88SC101_ZONE_TYPE_IZ = 1;
    public static final int AT88SC101_ZONE_TYPE_SC = 2;
    public static final int AT88SC101_ZONE_TYPE_SCAC = 3;
    public static final int AT88SC101_ZONE_TYPE_CPZ = 4;
    public static final int AT88SC101_ZONE_TYPE_AZ1 = 5;
    public static final int AT88SC101_ZONE_TYPE_EZ1 = 6;
    public static final int AT88SC101_ZONE_TYPE_EC = 7;
    public static final int AT88SC101_ZONE_TYPE_MTZ = 8;
    public static final int AT88SC102_ZONE_TYPE_FZ = 0;
    public static final int AT88SC102_ZONE_TYPE_IZ = 1;
    public static final int AT88SC102_ZONE_TYPE_SC = 2;
    public static final int AT88SC102_ZONE_TYPE_SCAC = 3;
    public static final int AT88SC102_ZONE_TYPE_CPZ = 4;
    public static final int AT88SC102_ZONE_TYPE_AZ1 = 5;
    public static final int AT88SC102_ZONE_TYPE_EZ1 = 6;
    public static final int AT88SC102_ZONE_TYPE_AZ2 = 7;
    public static final int AT88SC102_ZONE_TYPE_EZ2 = 8;
    public static final int AT88SC102_ZONE_TYPE_EC = 9;
    public static final int AT88SC102_ZONE_TYPE_MTZ = 10;
    public static final int AT88SC1604_ZONE_TYPE_FZ = 0;
    public static final int AT88SC1604_ZONE_TYPE_IZ = 1;
    public static final int AT88SC1604_ZONE_TYPE_SC = 2;
    public static final int AT88SC1604_ZONE_TYPE_SCAC = 3;
    public static final int AT88SC1604_ZONE_TYPE_CPZ = 4;
    public static final int AT88SC1604_ZONE_TYPE_SC1 = 5;
    public static final int AT88SC1604_ZONE_TYPE_S1AC = 6;
    public static final int AT88SC1604_ZONE_TYPE_EZ1 = 7;
    public static final int AT88SC1604_ZONE_TYPE_E1AC = 8;
    public static final int AT88SC1604_ZONE_TYPE_AZ1 = 9;
    public static final int AT88SC1604_ZONE_TYPE_SC2 = 10;
    public static final int AT88SC1604_ZONE_TYPE_EZ2 = 11;
    public static final int AT88SC1604_ZONE_TYPE_E2AC = 12;
    public static final int AT88SC1604_ZONE_TYPE_AZ2 = 13;
    public static final int AT88SC1604_ZONE_TYPE_SC3 = 14;
    public static final int AT88SC1604_ZONE_TYPE_EZ3 = 15;
    public static final int AT88SC1604_ZONE_TYPE_E3AC = 16;
    public static final int AT88SC1604_ZONE_TYPE_AZ3 = 17;
    public static final int AT88SC1604_ZONE_TYPE_SC4 = 18;
    public static final int AT88SC1604_ZONE_TYPE_EZ4 = 19;
    public static final int AT88SC1604_ZONE_TYPE_E4AC = 20;
    public static final int AT88SC1604_ZONE_TYPE_AZ4 = 21;
    public static final int AT88SC1604_ZONE_TYPE_MTZ = 22;
    public static final int AT88SC153_ZONE_TYPE_UZ0 = 0;
    public static final int AT88SC153_ZONE_TYPE_UZ1 = 1;
    public static final int AT88SC153_ZONE_TYPE_UZ2 = 2;
    public static final int AT88SC153_ZONE_TYPE_CZ = 3;
    public static final int AT88SC153_ZONE_TYPE_AZ = 4;
    public static final int AT88SC153_ZONE_TYPE_FZ = 5;
    public static final int AT88SC1608_ZONE_TYPE_UZ0 = 0;
    public static final int AT88SC1608_ZONE_TYPE_UZ1 = 1;
    public static final int AT88SC1608_ZONE_TYPE_UZ2 = 2;
    public static final int AT88SC1608_ZONE_TYPE_UZ3 = 3;
    public static final int AT88SC1608_ZONE_TYPE_UZ4 = 4;
    public static final int AT88SC1608_ZONE_TYPE_UZ5 = 5;
    public static final int AT88SC1608_ZONE_TYPE_UZ6 = 6;
    public static final int AT88SC1608_ZONE_TYPE_UZ7 = 7;
    public static final int AT88SC1608_ZONE_TYPE_CZ = 8;
    public static final int AT88SC1608_ZONE_TYPE_AZ = 9;
    public static final int AT88SC1608_ZONE_TYPE_FZ = 10;
    public static final int SLE4428_OP_FLAG_RW = 1;
    public static final int SLE4428_OP_FLAG_RW_WITH_BP = 2;
    public static final int AT88SC101_OP_FLAG_SL1 = 0;
    public static final int AT88SC101_OP_FLAG_SL2 = 1;
    public static final int AT88SC102_OP_FLAG_SL1 = 0;
    public static final int AT88SC102_OP_FLAG_SL2 = 1;
    public static final int AT88SC1604_OP_FLAG_SL1 = 0;
    public static final int AT88SC1604_OP_FLAG_SL2 = 1;
    public static final int AT88SC153_OP_FLAG_PW_R = 0;
    public static final int AT88SC153_OP_FLAG_PW_W = 1;
    public static final int AT88SC1608_OP_FLAG_PW_R = 0;
    public static final int AT88SC1608_OP_FLAG_PW_W = 1;
    public static final int AT88SC101_SP_FLAG_LSB = 0;
    public static final int AT88SC101_SP_FLAG_MSB = 1;
    public static final int AT88SC102_SP_FLAG_LSB = 0;
    public static final int AT88SC102_SP_FLAG_MSB = 1;
    public static final int AT88SC1604_SP_FLAG_LSB = 0;
    public static final int AT88SC1604_SP_FLAG_MSB = 1;
    private IPosMemoryCardReaderImpl mCardReader;
    private int mCardType;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosMemoryCardReader(IBinder iBinder) {
        this.mCardReader = IPosMemoryCardReaderImpl.Stub.asInterface(iBinder);
        this.mCardType = 7;
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int getSupportCardType() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        try {
            return this.mCardReader.getSupportCardType();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public boolean isSupportCardType(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        try {
            return this.mCardReader.isSupportCardType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    public synchronized void setCardType(int n) {
        this.mCardType = n;
    }

    public int open() {
        return this.open(this.mCardType, null);
    }

    public int open(PosByteArray posByteArray) {
        return this.open(this.mCardType, posByteArray);
    }

    public int open(int n, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n2 = -1;
        try {
            n2 = this.mCardReader.open(n, posByteArray, this.mCb);
            boolean bl = this.mDeviceOpened = n2 == 0;
            if (this.mDeviceOpened) {
                this.mCardType = n;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n2;
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int read(int n, int n2, PosByteArray posByteArray) {
        return this.read(this.mCardType, 0, n, n2, 0, 0, posByteArray);
    }

    public int read(int n, int n2, int n3, PosByteArray posByteArray) {
        return this.read(this.mCardType, n, n2, n3, 0, 0, posByteArray);
    }

    public int read(int n, int n2, int n3, int n4, int n5, PosByteArray posByteArray) {
        return this.read(this.mCardType, n, n2, n3, n4, n5, posByteArray);
    }

    public int read(int n, int n2, int n3, int n4, int n5, int n6, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "read:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.read(n, n2, n3, n4, n5, n6, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int write(int n, byte[] byArray) {
        return this.write(this.mCardType, 0, n, 0, 0, byArray);
    }

    public int write(int n, int n2, byte[] byArray) {
        return this.write(this.mCardType, n, n2, 0, 0, byArray);
    }

    public int write(int n, int n2, int n3, int n4, byte[] byArray) {
        return this.write(this.mCardType, n, n2, n3, n4, byArray);
    }

    public int write(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "write:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.write(n, n2, n3, n4, n5, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int verify(byte[] byArray) {
        return this.verify(this.mCardType, byArray);
    }

    public int verify(int n, byte[] byArray) {
        return this.verify(this.mCardType, n, 0, 0, byArray);
    }

    public int verify(int n, int n2, int n3, byte[] byArray) {
        return this.verify(this.mCardType, n, n2, n3, byArray);
    }

    public int verify(int n, int n2, int n3, int n4, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "verify:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.verify(n, n2, n3, n4, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int update(byte[] byArray) {
        return this.update(this.mCardType, byArray);
    }

    public int update(int n, byte[] byArray) {
        return this.update(this.mCardType, n, 0, 0, byArray);
    }

    public int update(int n, int n2, int n3, byte[] byArray) {
        return this.update(this.mCardType, n, n2, n3, byArray);
    }

    public int update(int n, int n2, int n3, int n4, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "update:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.update(n, n2, n3, n4, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int pac(PosByteArray posByteArray) {
        return this.pac(this.mCardType, 0, 0, 0, posByteArray);
    }

    public int pac(int n, PosByteArray posByteArray) {
        return this.pac(this.mCardType, n, 0, 0, posByteArray);
    }

    public int pac(int n, int n2, int n3, PosByteArray posByteArray) {
        return this.pac(this.mCardType, n, n2, n3, posByteArray);
    }

    public int pac(int n, int n2, int n3, int n4, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "pac:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.pac(n, n2, n3, n4, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int status() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        try {
            return this.mCardReader.status();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitRawCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitRawCmd(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }
}

