/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosMifareCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosUtils;

public class PosMifareCardReader {
    private static final String TAG = "PosMifareCardReader";
    public static final int CARD_TYPE_NONE = 0;
    public static final int CARD_TYPE_MIFARE_ULTRALIGHT = 1;
    public static final int CARD_TYPE_MIFARE_CLASSIC = 2;
    public static final int CARD_TYPE_MIFARE_PLUS = 4;
    public static final int CARD_TYPE_MIFARE_DESFIRE = 8;
    public static final int AUTH_KEY_TYPE_CLASSIC_A = 65;
    public static final int AUTH_KEY_TYPE_CLASSIC_B = 66;
    public static final int AUTH_KEY_TYPE_TDES = 84;
    public static final int AUTH_KEY_TYPE_AES = 83;
    public static final int CARDREADER_DETECT_MODE_M = 77;
    public static final int CARDREADER_DETECT_MODE_N = 78;
    public static final int CARDREADER_DETECT_MODE_X = 88;
    public static final int OPERATE_BLK_TYPE_ADD = 43;
    public static final int OPERATE_BLK_TYPE_SUBSTRACT = 45;
    public static final int OPERATE_BLK_TYPE_TRANSFER = 62;
    private IPosMifareCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosMifareCardReader(IBinder iBinder) {
        this.mCardReader = IPosMifareCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        return this.open(2);
    }

    public int open(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n2 = -1;
        try {
            n2 = this.mCardReader.open(n, this.mCb);
            this.mDeviceOpened = n2 == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n2;
    }

    public int detect() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int transmitApdu(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitApdu:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitApdu(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitRawCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitApdu(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int auth(int n, int n2, byte[] byArray) {
        return this.auth(n, n2, byArray, null);
    }

    public int auth(int n, int n2, byte[] byArray, byte[] byArray2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "auth:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.auth(n, n2, byArray, byArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int read(int n, PosByteArray posByteArray) {
        return this.read(0, n, 16, posByteArray);
    }

    public int read(int n, int n2, PosByteArray posByteArray) {
        return this.read(0, n, n2, posByteArray);
    }

    public int read(int n, int n2, int n3, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "read:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.read(n, n2, n3, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int write(int n, byte[] byArray) {
        return this.write(0, n, byArray);
    }

    public int write(int n, int n2, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "write:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.write(n, n2, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int operate(int n, int n2, int n3, int n4) {
        return this.operate(n, 0, n2, n3, PosUtils.intToBytesLe(n4));
    }

    public int operate(int n, int n2, int n3, byte[] byArray) {
        return this.operate(n, 0, n2, n3, byArray);
    }

    public int operate(int n, int n2, int n3, int n4, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "operate:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.operate(n, n2, n3, n4, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int removeCard() {
        return this.removeCard(-1, -1);
    }

    public int removeCard(int n) {
        return this.removeCard(n, -1);
    }

    public int removeCard(int n, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "removeCard:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.removeCard(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int detectEx(int n) {
        return this.detectEx(Integer.toString(n));
    }

    public int detectEx(String string) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detectEx:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detectEx(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setCardType(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setCardType:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.setCardType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }
}

