/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosPsamCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosTlv;

public class PosPsamCardReader {
    private static final String TAG = "PosPsamCardReader";
    public static final int DEFAULT_SLOT = 1;
    private IPosPsamCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;
    private int mSlot;

    protected PosPsamCardReader(IBinder iBinder) {
        this.mCardReader = IPosPsamCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
        this.mSlot = 1;
    }

    public int getNumberOfSlots() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        try {
            return this.mCardReader.getNumberOfSlots();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int open() {
        return this.open(this.mSlot, null);
    }

    public int open(int n) {
        return this.open(n, null);
    }

    public int open(int n, int n2) {
        if (!PosPsamCardReader.isValidBaudrate(n2)) {
            PosLog.e(TAG, "open:: invalid parameters: baudrate= " + n2);
            return -1;
        }
        return this.open(n, PosTlv.constructTlvObject(65, (byte)(n2 & 0xFF)));
    }

    public int open(int n, int n2, int n3) {
        if (!PosPsamCardReader.isValidBaudrate(n2) || !PosPsamCardReader.isValidPowerVol(n3)) {
            PosLog.e(TAG, "open:: invalid parameters: baudrate= " + n2 + ", voltage= " + n3);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(65, (byte)(n2 & 0xFF));
        byte[] byArray2 = PosTlv.constructTlvObject(66, (byte)(n3 & 0xFF));
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return this.open(n, byArray3);
    }

    public int openWithPowerVol(int n, int n2) {
        if (!PosPsamCardReader.isValidPowerVol(n2)) {
            PosLog.e(TAG, "openWithPowerVol:: invalid parameters: voltage= " + n2);
            return -1;
        }
        return this.open(n, PosTlv.constructTlvObject(66, (byte)(n2 & 0xFF)));
    }

    public int openWithWTX(int n, int n2) {
        return this.open(n, PosTlv.constructTlvObject(67, (byte)(n2 & 0xFF)));
    }

    public int open(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened && SystemProperties.getInt((String)"persist.sys.psam_continu_open", (int)0) == 0) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n2 = -1;
        try {
            n2 = this.mCardReader.open(n, byArray, this.mCb);
            boolean bl = this.mDeviceOpened = n2 == 0;
            if (this.mDeviceOpened) {
                this.mSlot = n;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n2;
    }

    public int detect() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int reset() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "mIsOpened:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.reset();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public void setTransmitApduTimeout(long l) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setTransmitApduTimeout:: device is not opened!");
            return;
        }
        try {
            this.mCardReader.setTransmitApduTimeout(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setTransmitApduGetRspType(int n) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setTransmitApduGetRspType:: device is not opened!");
            return;
        }
        try {
            this.mCardReader.setTransmitApduGetRspType(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int transmitApdu(byte[] byArray, PosByteArray posByteArray, PosByteArray posByteArray2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitApdu:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitApdu(byArray, posByteArray, posByteArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            boolean bl = this.mDeviceOpened = n != 0;
            if (!this.mDeviceOpened) {
                this.mSlot = 1;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int switchSlot(int n, int n2) {
        if (!PosPsamCardReader.isValidBaudrate(n2)) {
            PosLog.e(TAG, "switchSlot:: invalid parameters: baudrate= " + n2);
            return -1;
        }
        return this.switchSlot(n, PosTlv.constructTlvObject(65, (byte)(n2 & 0xFF)));
    }

    public int switchSlot(int n, int n2, int n3) {
        if (!PosPsamCardReader.isValidBaudrate(n2) || !PosPsamCardReader.isValidPowerVol(n3)) {
            PosLog.e(TAG, "switchSlot:: invalid parameters baudrate= " + n2 + ", voltage= " + n3);
            return -1;
        }
        byte[] byArray = PosTlv.constructTlvObject(65, (byte)(n2 & 0xFF));
        byte[] byArray2 = PosTlv.constructTlvObject(66, (byte)(n3 & 0xFF));
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return this.switchSlot(n, byArray3);
    }

    public int switchSlotWithPowerVol(int n, int n2) {
        if (!PosPsamCardReader.isValidPowerVol(n2)) {
            PosLog.e(TAG, "switchSlotWithPowerVol:: invalid parameters: voltage= " + n2);
            return -1;
        }
        return this.switchSlot(n, PosTlv.constructTlvObject(66, (byte)(n2 & 0xFF)));
    }

    public int switchSlot(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "switchSlot:: device is not opened!");
            return -1;
        }
        int n2 = -1;
        try {
            n2 = this.mCardReader.switchSlot(n, byArray);
            if (n2 == 0) {
                this.mSlot = n;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return -1;
    }

    public int setBaudrate(int n) {
        if (!PosPsamCardReader.isValidBaudrate(n)) {
            PosLog.e(TAG, "setBaudrate:: invalid parameters: baudrate= " + n);
            return -1;
        }
        return this.switchSlot(this.mSlot, PosTlv.constructTlvObject(65, (byte)(n & 0xFF)));
    }

    public int setPowerVol(int n) {
        if (!PosPsamCardReader.isValidPowerVol(n)) {
            PosLog.e(TAG, "setPowerVol:: invalid parameters: voltage= " + n);
            return -1;
        }
        return this.switchSlot(this.mSlot, PosTlv.constructTlvObject(66, (byte)(n & 0xFF)));
    }

    private static boolean isValidBaudrate(int n) {
        switch (n) {
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidPowerVol(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

