/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosSidCardReaderImpl;
import com.pos.sdk.cardreader.PosCardReaderInfo;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosParameters;

public class PosSidCardReader {
    private static final String TAG = "PosSidCardReader";
    private IPosSidCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private IBinder mCb;

    protected PosSidCardReader(IBinder iBinder) {
        this.mCardReader = IPosSidCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.open(this.mCb);
            this.mDeviceOpened = n == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int detect() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "detect:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.detect();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PosCardReaderInfo getCardReaderInfo() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getCardReaderInfo:: device is not opened!");
            return null;
        }
        try {
            return this.mCardReader.getCardReaderInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int transmitCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitCmd(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitRawCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitRawCmd(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int removeCard() {
        return this.removeCard(-1, -1);
    }

    public int removeCard(int n) {
        return this.removeCard(n, -1);
    }

    public int removeCard(int n, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "removeCard:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.removeCard(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int setParameters(Parameters parameters) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "setParameters:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.setParameters(parameters.flatten());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public Parameters getParameters() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getParameters:: device is not opened!");
            return null;
        }
        try {
            Parameters parameters = new Parameters();
            String string = this.mCardReader.getParameters();
            parameters.unflatten(string);
            return parameters;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public static class Parameters
    extends PosParameters {
        public static final String KEY_TYPE = "sid-type";
        public static final String KEY_READER_RATE = "sid-reader-rate";
        public static final String KEY_CARD_RATE = "sid-card-rate";
        public static final String KEY_FRAME_MODE = "sid-frame-mode";
        public static final String KEY_FRAME_WAIT_TIME = "sid-frame-wait-time";
        public static final String KEY_FRAME_GUARD_TIME = "sid-frame-guard-time";
        public static final String KEY_FRAME_SIZE = "sid-frame-size";
        public static final String KEY_CRC_ENABLE = "sid-crc-enable";

        public void setType(int n) {
            this.set(KEY_TYPE, n);
        }

        public int getType() {
            return this.getInt(KEY_TYPE);
        }

        public void setReaderRate(int n) {
            this.set(KEY_READER_RATE, n);
        }

        public int getReaderRate() {
            return this.getInt(KEY_READER_RATE);
        }

        public void setCardRate(int n) {
            this.set(KEY_CARD_RATE, n);
        }

        public int getCardRate() {
            return this.getInt(KEY_CARD_RATE);
        }

        public void setFrameMode(int n) {
            this.set(KEY_FRAME_MODE, n);
        }

        public int getFrameMode() {
            return this.getInt(KEY_FRAME_MODE);
        }

        public void setFrameWaitTime(int n) {
            this.set(KEY_FRAME_WAIT_TIME, n);
        }

        public int getFrameWaitTime() {
            return this.getInt(KEY_FRAME_WAIT_TIME);
        }

        public void setFrameGuardTime(int n) {
            this.set(KEY_FRAME_GUARD_TIME, n);
        }

        public int getFrameGuardTime() {
            return this.getInt(KEY_FRAME_GUARD_TIME);
        }

        public void setFrameSize(int n) {
            this.set(KEY_FRAME_SIZE, n);
        }

        public int getFrameSize() {
            return this.getInt(KEY_FRAME_SIZE);
        }

        public void setCrcEnable(boolean bl) {
            this.set(KEY_CRC_ENABLE, bl);
        }

        public boolean getCrcEnable() {
            return this.getBoolean(KEY_CRC_ENABLE);
        }
    }
}

