/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.cardreader;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.pos.sdk.PosLog;
import com.pos.sdk.cardreader.IPosViccCardReaderImpl;
import com.pos.sdk.utils.PosByteArray;

public class PosViccCardReader {
    private static final String TAG = "PosViccCardReader";
    public static final int MODE_ISO15693 = 5;
    private IPosViccCardReaderImpl mCardReader;
    private boolean mDeviceOpened;
    private int mMode;
    private IBinder mCb;

    protected PosViccCardReader(IBinder iBinder) {
        this.mCardReader = IPosViccCardReaderImpl.Stub.asInterface(iBinder);
        this.mDeviceOpened = false;
        this.mCb = new Binder();
    }

    public int open() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (this.mDeviceOpened) {
            PosLog.e(TAG, "open:: device is already opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.open(this.mCb);
            this.mDeviceOpened = n == 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }

    public int inventory(PosByteArray posByteArray) {
        return this.inventory(5, -1, posByteArray);
    }

    public int inventory(int n, PosByteArray posByteArray) {
        return this.inventory(5, n, posByteArray);
    }

    public int inventory(int n, int n2, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "inventory:: device is not opened!");
            return -1;
        }
        try {
            this.mMode = n;
            return this.mCardReader.inventory(this.mMode, n2, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int quiet(byte[] byArray) {
        return this.quiet(this.mMode, byArray);
    }

    public int quiet(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "quiet:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.quiet(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int readBlock(int n, PosByteArray posByteArray) {
        return this.readBlock(this.mMode, null, n, false, posByteArray);
    }

    public int readBlock(byte[] byArray, int n, PosByteArray posByteArray) {
        return this.readBlock(this.mMode, byArray, n, false, posByteArray);
    }

    public int readBlock(int n, boolean bl, PosByteArray posByteArray) {
        return this.readBlock(this.mMode, null, n, bl, posByteArray);
    }

    public int readBlock(byte[] byArray, int n, boolean bl, PosByteArray posByteArray) {
        return this.readBlock(this.mMode, byArray, n, bl, posByteArray);
    }

    public int readBlock(int n, byte[] byArray, int n2, boolean bl, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "readBlock:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.readBlock(n, byArray, n2, bl, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int writeBlock(int n, byte[] byArray) {
        return this.writeBlock(this.mMode, null, n, byArray);
    }

    public int writeBlock(byte[] byArray, int n, byte[] byArray2) {
        return this.writeBlock(this.mMode, byArray, n, byArray2);
    }

    public int writeBlock(int n, byte[] byArray, int n2, byte[] byArray2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "writeBlock:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.writeBlock(n, byArray, n2, byArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int lockBlock(int n) {
        return this.lockBlock(this.mMode, null, n);
    }

    public int lockBlock(byte[] byArray, int n) {
        return this.lockBlock(this.mMode, byArray, n);
    }

    public int lockBlock(int n, byte[] byArray, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "lockBlock:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.lockBlock(n, byArray, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int readMultiBlock(int n, int n2, PosByteArray posByteArray) {
        return this.readMultiBlock(this.mMode, null, n, n2, false, posByteArray);
    }

    public int readMultiBlock(int n, int n2, boolean bl, PosByteArray posByteArray) {
        return this.readMultiBlock(this.mMode, null, n, n2, bl, posByteArray);
    }

    public int readMultiBlock(byte[] byArray, int n, int n2, boolean bl, PosByteArray posByteArray) {
        return this.readMultiBlock(this.mMode, byArray, n, n2, bl, posByteArray);
    }

    public int readMultiBlock(int n, byte[] byArray, int n2, int n3, boolean bl, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "readMultiBlock:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.readMultiBlock(n, byArray, n2, n3, bl, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int writeMultiBlock(int n, int n2, byte[] byArray) {
        return this.writeMultiBlock(this.mMode, null, n, n2, byArray);
    }

    public int writeMultiBlock(byte[] byArray, int n, int n2, byte[] byArray2) {
        return this.writeMultiBlock(this.mMode, byArray, n, n2, byArray2);
    }

    public int writeMultiBlock(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "writeMultiBlock:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.writeMultiBlock(n, byArray, n2, n3, byArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int select(byte[] byArray) {
        return this.select(this.mMode, byArray);
    }

    public int select(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "select:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.select(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int reset() {
        return this.reset(this.mMode, null);
    }

    public int reset(byte[] byArray) {
        return this.reset(this.mMode, byArray);
    }

    public int reset(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "reset:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.reset(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int writeAFI(int n) {
        return this.writeAFI(this.mMode, null, n);
    }

    public int writeAFI(byte[] byArray, int n) {
        return this.writeAFI(this.mMode, byArray, n);
    }

    public int writeAFI(int n, byte[] byArray, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "writeAFI:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.writeAFI(n, byArray, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int lockAFI() {
        return this.lockAFI(this.mMode, null);
    }

    public int lockAFI(byte[] byArray) {
        return this.lockAFI(this.mMode, byArray);
    }

    public int lockAFI(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "lockAFI:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.lockAFI(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int writeDSFID(int n) {
        return this.writeDSFID(this.mMode, null, n);
    }

    public int writeDSFID(byte[] byArray, int n) {
        return this.writeDSFID(this.mMode, byArray, n);
    }

    public int writeDSFID(int n, byte[] byArray, int n2) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "writeDSFID:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.writeDSFID(n, byArray, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int lockDSFID() {
        return this.lockDSFID(this.mMode, null);
    }

    public int lockDSFID(byte[] byArray) {
        return this.lockDSFID(this.mMode, byArray);
    }

    public int lockDSFID(int n, byte[] byArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "lockDSFID:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.lockDSFID(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getSystemInfo(PosByteArray posByteArray) {
        return this.getSystemInfo(this.mMode, null, posByteArray);
    }

    public int getSystemInfo(byte[] byArray, PosByteArray posByteArray) {
        return this.getSystemInfo(this.mMode, byArray, posByteArray);
    }

    public int getSystemInfo(int n, byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getSystemInfo:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.getSystemInfo(n, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getMultiBlockSecurityStatus(int n, int n2, PosByteArray posByteArray) {
        return this.getMultiBlockSecurityStatus(this.mMode, null, n, n2, posByteArray);
    }

    public int getMultiBlockSecurityStatus(byte[] byArray, int n, int n2, PosByteArray posByteArray) {
        return this.getMultiBlockSecurityStatus(this.mMode, byArray, n, n2, posByteArray);
    }

    public int getMultiBlockSecurityStatus(int n, byte[] byArray, int n2, int n3, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "getMultiBlockSecurityStatus:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.getMultiBlockSecurityStatus(n, byArray, n2, n3, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int transmitRawCmd(byte[] byArray, PosByteArray posByteArray) {
        return this.transmitRawCmd(this.mMode, byArray, posByteArray);
    }

    public int transmitRawCmd(int n, byte[] byArray, PosByteArray posByteArray) {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "transmitRawCmd:: device is not opened!");
            return -1;
        }
        try {
            return this.mCardReader.transmitRawCmd(n, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int close() {
        if (this.mCardReader == null) {
            throw new NullPointerException("mCardReader is null!!");
        }
        if (!this.mDeviceOpened) {
            PosLog.e(TAG, "close:: device is not opened!");
            return -1;
        }
        int n = -1;
        try {
            n = this.mCardReader.close(this.mCb);
            this.mDeviceOpened = n != 0;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return n;
    }
}

