/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.printer;

import android.graphics.Bitmap;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.pos.sdk.printer.IPosPrinterListener;
import com.pos.sdk.printer.PosPrintData;
import com.pos.sdk.printer.PosPrintStateInfo;
import java.util.ArrayList;
import java.util.List;

public interface IPosPrinter
extends IInterface {
    public void registerListener(IPosPrinterListener var1) throws RemoteException;

    public void unregisterListener(IPosPrinterListener var1) throws RemoteException;

    public void release() throws RemoteException;

    public void setParameters(String var1) throws RemoteException;

    public String getParameters() throws RemoteException;

    public void getPrintStateInfo(PosPrintStateInfo var1) throws RemoteException;

    public int setCursor(int var1, int var2) throws RemoteException;

    public int addTextToCache(String var1, int var2, int var3) throws RemoteException;

    public int addTextToCurCache(String var1) throws RemoteException;

    public int addBmpToCache(String var1, int var2, int var3) throws RemoteException;

    public int addBmpToCurCache(String var1) throws RemoteException;

    public int cleanCache() throws RemoteException;

    public int print() throws RemoteException;

    public int printText(String var1) throws RemoteException;

    public int printBmp(String var1) throws RemoteException;

    public int setPrintCtrlFeed(int var1, int var2, int var3) throws RemoteException;

    public int addRawDataToCache(byte[] var1) throws RemoteException;

    public int printRawData(byte[] var1) throws RemoteException;

    public int addBitmapToCache(Bitmap var1) throws RemoteException;

    public int printBitmap(Bitmap var1) throws RemoteException;

    public int addBatchDataToCache(List<PosPrintData> var1) throws RemoteException;

    public int printBatchData(List<PosPrintData> var1) throws RemoteException;

    public int getTotalPixLineCnt() throws RemoteException;

    public int getBeforePixLineCnt() throws RemoteException;

    public long getCurrentEndPrintTime() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPosPrinter {
        private static final String DESCRIPTOR = "com.pos.sdk.printer.IPosPrinter";
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_unregisterListener = 2;
        static final int TRANSACTION_release = 3;
        static final int TRANSACTION_setParameters = 4;
        static final int TRANSACTION_getParameters = 5;
        static final int TRANSACTION_getPrintStateInfo = 6;
        static final int TRANSACTION_setCursor = 7;
        static final int TRANSACTION_addTextToCache = 8;
        static final int TRANSACTION_addTextToCurCache = 9;
        static final int TRANSACTION_addBmpToCache = 10;
        static final int TRANSACTION_addBmpToCurCache = 11;
        static final int TRANSACTION_cleanCache = 12;
        static final int TRANSACTION_print = 13;
        static final int TRANSACTION_printText = 14;
        static final int TRANSACTION_printBmp = 15;
        static final int TRANSACTION_setPrintCtrlFeed = 16;
        static final int TRANSACTION_addRawDataToCache = 17;
        static final int TRANSACTION_printRawData = 18;
        static final int TRANSACTION_addBitmapToCache = 19;
        static final int TRANSACTION_printBitmap = 20;
        static final int TRANSACTION_addBatchDataToCache = 21;
        static final int TRANSACTION_printBatchData = 22;
        static final int TRANSACTION_getTotalPixLineCnt = 23;
        static final int TRANSACTION_getBeforePixLineCnt = 24;
        static final int TRANSACTION_getCurrentEndPrintTime = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPosPrinter asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPosPrinter) {
                return (IPosPrinter)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            String string = DESCRIPTOR;
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(string);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(string);
                    IPosPrinterListener iPosPrinterListener = IPosPrinterListener.Stub.asInterface(parcel.readStrongBinder());
                    this.registerListener(iPosPrinterListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(string);
                    IPosPrinterListener iPosPrinterListener = IPosPrinterListener.Stub.asInterface(parcel.readStrongBinder());
                    this.unregisterListener(iPosPrinterListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(string);
                    this.release();
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(string);
                    String string2 = parcel.readString();
                    this.setParameters(string2);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(string);
                    String string3 = this.getParameters();
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(string);
                    PosPrintStateInfo posPrintStateInfo = new PosPrintStateInfo();
                    this.getPrintStateInfo(posPrintStateInfo);
                    parcel2.writeNoException();
                    if (posPrintStateInfo != null) {
                        parcel2.writeInt(1);
                        posPrintStateInfo.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(string);
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    int n5 = this.setCursor(n3, n4);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(string);
                    String string4 = parcel.readString();
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = this.addTextToCache(string4, n6, n7);
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(string);
                    String string5 = parcel.readString();
                    int n9 = this.addTextToCurCache(string5);
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(string);
                    String string6 = parcel.readString();
                    int n10 = parcel.readInt();
                    int n11 = parcel.readInt();
                    int n12 = this.addBmpToCache(string6, n10, n11);
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(string);
                    String string7 = parcel.readString();
                    int n13 = this.addBmpToCurCache(string7);
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(string);
                    int n14 = this.cleanCache();
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(string);
                    int n15 = this.print();
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(string);
                    String string8 = parcel.readString();
                    int n16 = this.printText(string8);
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(string);
                    String string9 = parcel.readString();
                    int n17 = this.printBmp(string9);
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(string);
                    int n18 = parcel.readInt();
                    int n19 = parcel.readInt();
                    int n20 = parcel.readInt();
                    int n21 = this.setPrintCtrlFeed(n18, n19, n20);
                    parcel2.writeNoException();
                    parcel2.writeInt(n21);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(string);
                    byte[] byArray = parcel.createByteArray();
                    int n22 = this.addRawDataToCache(byArray);
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(string);
                    byte[] byArray = parcel.createByteArray();
                    int n23 = this.printRawData(byArray);
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(string);
                    Bitmap bitmap = 0 != parcel.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(parcel) : null;
                    int n24 = this.addBitmapToCache(bitmap);
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(string);
                    Bitmap bitmap = 0 != parcel.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(parcel) : null;
                    int n25 = this.printBitmap(bitmap);
                    parcel2.writeNoException();
                    parcel2.writeInt(n25);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(string);
                    ArrayList arrayList = parcel.createTypedArrayList(PosPrintData.CREATOR);
                    int n26 = this.addBatchDataToCache(arrayList);
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(string);
                    ArrayList arrayList = parcel.createTypedArrayList(PosPrintData.CREATOR);
                    int n27 = this.printBatchData(arrayList);
                    parcel2.writeNoException();
                    parcel2.writeInt(n27);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(string);
                    int n28 = this.getTotalPixLineCnt();
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(string);
                    int n29 = this.getBeforePixLineCnt();
                    parcel2.writeNoException();
                    parcel2.writeInt(n29);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(string);
                    long l = this.getCurrentEndPrintTime();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        public static boolean setDefaultImpl(IPosPrinter iPosPrinter) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (iPosPrinter != null) {
                Proxy.sDefaultImpl = iPosPrinter;
                return true;
            }
            return false;
        }

        public static IPosPrinter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPosPrinter {
            private IBinder mRemote;
            public static IPosPrinter sDefaultImpl;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(IPosPrinterListener iPosPrinterListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iPosPrinterListener != null ? iPosPrinterListener.asBinder() : null);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerListener(iPosPrinterListener);
                        return;
                    }
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(IPosPrinterListener iPosPrinterListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iPosPrinterListener != null ? iPosPrinterListener.asBinder() : null);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterListener(iPosPrinterListener);
                        return;
                    }
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void release() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().release();
                        return;
                    }
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setParameters(String string) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setParameters(string);
                        return;
                    }
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getParameters() throws RemoteException {
                String string;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getParameters();
                        return string2;
                    }
                    parcel2.readException();
                    string = parcel2.readString();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrintStateInfo(PosPrintStateInfo posPrintStateInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPrintStateInfo(posPrintStateInfo);
                        return;
                    }
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        posPrintStateInfo.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setCursor(int n, int n2) throws RemoteException {
                int n3;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n4 = Stub.getDefaultImpl().setCursor(n, n2);
                        return n4;
                    }
                    parcel2.readException();
                    n3 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addTextToCache(String string, int n, int n2) throws RemoteException {
                int n3;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n4 = Stub.getDefaultImpl().addTextToCache(string, n, n2);
                        return n4;
                    }
                    parcel2.readException();
                    n3 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addTextToCurCache(String string) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().addTextToCurCache(string);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addBmpToCache(String string, int n, int n2) throws RemoteException {
                int n3;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n4 = Stub.getDefaultImpl().addBmpToCache(string, n, n2);
                        return n4;
                    }
                    parcel2.readException();
                    n3 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addBmpToCurCache(String string) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().addBmpToCurCache(string);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cleanCache() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().cleanCache();
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int print() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().print();
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int printText(String string) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().printText(string);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int printBmp(String string) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string);
                    boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().printBmp(string);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPrintCtrlFeed(int n, int n2, int n3) throws RemoteException {
                int n4;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    boolean bl = this.mRemote.transact(16, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n5 = Stub.getDefaultImpl().setPrintCtrlFeed(n, n2, n3);
                        return n5;
                    }
                    parcel2.readException();
                    n4 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n4;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addRawDataToCache(byte[] byArray) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeByteArray(byArray);
                    boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().addRawDataToCache(byArray);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int printRawData(byte[] byArray) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeByteArray(byArray);
                    boolean bl = this.mRemote.transact(18, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().printRawData(byArray);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addBitmapToCache(Bitmap bitmap) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        parcel.writeInt(1);
                        bitmap.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(19, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().addBitmapToCache(bitmap);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int printBitmap(Bitmap bitmap) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        parcel.writeInt(1);
                        bitmap.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(20, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().printBitmap(bitmap);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addBatchDataToCache(List<PosPrintData> list) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedList(list);
                    boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().addBatchDataToCache(list);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int printBatchData(List<PosPrintData> list) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedList(list);
                    boolean bl = this.mRemote.transact(22, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().printBatchData(list);
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTotalPixLineCnt() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(23, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().getTotalPixLineCnt();
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBeforePixLineCnt() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().getBeforePixLineCnt();
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCurrentEndPrintTime() throws RemoteException {
                long l;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        long l2 = Stub.getDefaultImpl().getCurrentEndPrintTime();
                        return l2;
                    }
                    parcel2.readException();
                    l = parcel2.readLong();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return l;
            }
        }
    }

    public static class Default
    implements IPosPrinter {
        @Override
        public void registerListener(IPosPrinterListener iPosPrinterListener) throws RemoteException {
        }

        @Override
        public void unregisterListener(IPosPrinterListener iPosPrinterListener) throws RemoteException {
        }

        @Override
        public void release() throws RemoteException {
        }

        @Override
        public void setParameters(String string) throws RemoteException {
        }

        @Override
        public String getParameters() throws RemoteException {
            return null;
        }

        @Override
        public void getPrintStateInfo(PosPrintStateInfo posPrintStateInfo) throws RemoteException {
        }

        @Override
        public int setCursor(int n, int n2) throws RemoteException {
            return 0;
        }

        @Override
        public int addTextToCache(String string, int n, int n2) throws RemoteException {
            return 0;
        }

        @Override
        public int addTextToCurCache(String string) throws RemoteException {
            return 0;
        }

        @Override
        public int addBmpToCache(String string, int n, int n2) throws RemoteException {
            return 0;
        }

        @Override
        public int addBmpToCurCache(String string) throws RemoteException {
            return 0;
        }

        @Override
        public int cleanCache() throws RemoteException {
            return 0;
        }

        @Override
        public int print() throws RemoteException {
            return 0;
        }

        @Override
        public int printText(String string) throws RemoteException {
            return 0;
        }

        @Override
        public int printBmp(String string) throws RemoteException {
            return 0;
        }

        @Override
        public int setPrintCtrlFeed(int n, int n2, int n3) throws RemoteException {
            return 0;
        }

        @Override
        public int addRawDataToCache(byte[] byArray) throws RemoteException {
            return 0;
        }

        @Override
        public int printRawData(byte[] byArray) throws RemoteException {
            return 0;
        }

        @Override
        public int addBitmapToCache(Bitmap bitmap) throws RemoteException {
            return 0;
        }

        @Override
        public int printBitmap(Bitmap bitmap) throws RemoteException {
            return 0;
        }

        @Override
        public int addBatchDataToCache(List<PosPrintData> list) throws RemoteException {
            return 0;
        }

        @Override
        public int printBatchData(List<PosPrintData> list) throws RemoteException {
            return 0;
        }

        @Override
        public int getTotalPixLineCnt() throws RemoteException {
            return 0;
        }

        @Override
        public int getBeforePixLineCnt() throws RemoteException {
            return 0;
        }

        @Override
        public long getCurrentEndPrintTime() throws RemoteException {
            return 0L;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

