/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.printer;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.pos.sdk.printer.IPosPrinter;
import com.pos.sdk.printer.PosPrintStateInfo;
import com.pos.sdk.printer.PosPrinterInfo;

public interface IPosPrinterService
extends IInterface {
    public int getNumberOfPrinters() throws RemoteException;

    public void getPrinterInfo(int var1, PosPrinterInfo var2) throws RemoteException;

    public PosPrintStateInfo getPrintStateInfo(int var1) throws RemoteException;

    public IPosPrinter createPrinter(int var1, IBinder var2) throws RemoteException;

    public void removePrinter(IPosPrinter var1, IBinder var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPosPrinterService {
        private static final String DESCRIPTOR = "com.pos.sdk.printer.IPosPrinterService";
        static final int TRANSACTION_getNumberOfPrinters = 1;
        static final int TRANSACTION_getPrinterInfo = 2;
        static final int TRANSACTION_getPrintStateInfo = 3;
        static final int TRANSACTION_createPrinter = 4;
        static final int TRANSACTION_removePrinter = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPosPrinterService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPosPrinterService) {
                return (IPosPrinterService)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            String string = DESCRIPTOR;
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(string);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(string);
                    int n3 = this.getNumberOfPrinters();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(string);
                    int n4 = parcel.readInt();
                    PosPrinterInfo posPrinterInfo = new PosPrinterInfo();
                    this.getPrinterInfo(n4, posPrinterInfo);
                    parcel2.writeNoException();
                    if (posPrinterInfo != null) {
                        parcel2.writeInt(1);
                        posPrinterInfo.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(string);
                    int n5 = parcel.readInt();
                    PosPrintStateInfo posPrintStateInfo = this.getPrintStateInfo(n5);
                    parcel2.writeNoException();
                    if (posPrintStateInfo != null) {
                        parcel2.writeInt(1);
                        posPrintStateInfo.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(string);
                    int n6 = parcel.readInt();
                    IBinder iBinder = parcel.readStrongBinder();
                    IPosPrinter iPosPrinter = this.createPrinter(n6, iBinder);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iPosPrinter != null ? iPosPrinter.asBinder() : null);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(string);
                    IPosPrinter iPosPrinter = IPosPrinter.Stub.asInterface(parcel.readStrongBinder());
                    IBinder iBinder = parcel.readStrongBinder();
                    this.removePrinter(iPosPrinter, iBinder);
                    parcel2.writeNoException();
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        public static boolean setDefaultImpl(IPosPrinterService iPosPrinterService) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (iPosPrinterService != null) {
                Proxy.sDefaultImpl = iPosPrinterService;
                return true;
            }
            return false;
        }

        public static IPosPrinterService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPosPrinterService {
            private IBinder mRemote;
            public static IPosPrinterService sDefaultImpl;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNumberOfPrinters() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().getNumberOfPrinters();
                        return n2;
                    }
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrinterInfo(int n, PosPrinterInfo posPrinterInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPrinterInfo(n, posPrinterInfo);
                        return;
                    }
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        posPrinterInfo.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PosPrintStateInfo getPrintStateInfo(int n) throws RemoteException {
                PosPrintStateInfo posPrintStateInfo;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        PosPrintStateInfo posPrintStateInfo2 = Stub.getDefaultImpl().getPrintStateInfo(n);
                        return posPrintStateInfo2;
                    }
                    parcel2.readException();
                    posPrintStateInfo = 0 != parcel2.readInt() ? (PosPrintStateInfo)PosPrintStateInfo.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return posPrintStateInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPosPrinter createPrinter(int n, IBinder iBinder) throws RemoteException {
                IPosPrinter iPosPrinter;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        IPosPrinter iPosPrinter2 = Stub.getDefaultImpl().createPrinter(n, iBinder);
                        return iPosPrinter2;
                    }
                    parcel2.readException();
                    iPosPrinter = IPosPrinter.Stub.asInterface(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPosPrinter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrinter(IPosPrinter iPosPrinter, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iPosPrinter != null ? iPosPrinter.asBinder() : null);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    if (!bl && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removePrinter(iPosPrinter, iBinder);
                        return;
                    }
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPosPrinterService {
        @Override
        public int getNumberOfPrinters() throws RemoteException {
            return 0;
        }

        @Override
        public void getPrinterInfo(int n, PosPrinterInfo posPrinterInfo) throws RemoteException {
        }

        @Override
        public PosPrintStateInfo getPrintStateInfo(int n) throws RemoteException {
            return null;
        }

        @Override
        public IPosPrinter createPrinter(int n, IBinder iBinder) throws RemoteException {
            return null;
        }

        @Override
        public void removePrinter(IPosPrinter iPosPrinter, IBinder iBinder) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

