/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.printer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.PowerManager;
import android.os.SystemProperties;
import com.pos.sdk.PosLog;
import com.pos.sdk.accessory.POIGeneralAPI;
import com.pos.sdk.printer.PosPrintStateInfo;
import com.pos.sdk.printer.PosPrinter;
import com.pos.sdk.printer.models.BitmapPrintLine;
import com.pos.sdk.printer.models.PrintLine;
import com.pos.sdk.printer.models.PrinterLayout;
import com.pos.sdk.printer.models.TextPrintLine;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosUtils;
import java.math.BigDecimal;
import java.util.List;

public class POIPrinterManager {
    private static final String TAG = "POIPrinterManager";
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_PRINTING = 1;
    public static final int STATUS_OVERHEAT = 2;
    public static final int STATUS_NO_PAPER = 3;
    public static final int STATUS_NO_PRINTER = 4;
    public static final int ERROR_INIT = -1;
    public static final int ERROR_PRINT = -2;
    public static final int ERROR_OVERHEAT = -3;
    public static final int ERROR_NO_PAPER = -4;
    public static final int ERROR_OTHER = -999;
    private static final int PRINTER_LENGTH_SCALE = 2;
    private static final int PRINTER_LENGTH_SCALE_HEIGHT = 8;
    private Context context;
    private int openId;
    private boolean isReceiver;
    private String printMode = "00";
    private volatile int status;
    private PosPrinter printer;
    private PrinterLayout printerLayout;
    private ViewToBitmapListener viewToBitmapListener;
    private IPrinterListener listener;
    private int linePixels = 30;
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            POIPrinterManager.this.printer = null;
            POIPrinterManager.this.status = 4;
            int n = PosPrinter.getNumberOfPrinters();
            if (n > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                POIPrinterManager.this.printer = PosPrinter.open(POIPrinterManager.this.openId);
                POIPrinterManager.this.status = 0;
            }
        }
    };
    private PosPrinter.EventListener eventListener = new PosPrinter.EventListener(){

        @Override
        public void onCursorChanged(PosPrinter posPrinter, int n, int n2, int n3, int n4) {
        }

        @Override
        public void onError(PosPrinter posPrinter, int n, int n2) {
            switch (n) {
                case 1: {
                    if (POIPrinterManager.this.listener != null) {
                        POIPrinterManager.this.listener.onError(-3, "Printer overheat.");
                    }
                    if (SystemProperties.getInt((String)"persist.sys.print_heat_notice", (int)0) != 1) break;
                    Intent intent = new Intent("com.pos.action.PRINT_OVER_HEAT");
                    intent.setFlags(0x20000000);
                    POIPrinterManager.this.context.sendStickyBroadcast(intent);
                    break;
                }
                case 2: {
                    if (POIPrinterManager.this.listener == null) break;
                    POIPrinterManager.this.listener.onError(-4, "Printer no paper.");
                    break;
                }
                default: {
                    if (POIPrinterManager.this.listener == null) break;
                    POIPrinterManager.this.listener.onError(-999, "Printer other error.");
                }
            }
        }

        @Override
        public void onInfo(PosPrinter posPrinter, int n, int n2) {
            PosPrintStateInfo posPrintStateInfo = new PosPrintStateInfo();
            posPrinter.getPrintStateInfo(posPrintStateInfo);
            switch (posPrintStateInfo.mState) {
                case 3: {
                    if (POIPrinterManager.this.listener == null) break;
                    POIPrinterManager.this.listener.onStart();
                    break;
                }
                case 1: {
                    if (POIPrinterManager.this.listener == null) break;
                    POIPrinterManager.this.listener.onFinish();
                    break;
                }
            }
        }
    };

    public POIPrinterManager(Context context) {
        this.context = context;
        this.viewToBitmapListener = new ViewToBitmapListener();
        this.openId = 0;
        this.status = 4;
    }

    public void open() {
        int n = PosPrinter.getNumberOfPrinters();
        if (n == 0) {
            this.status = 4;
            return;
        }
        PosByteArray posByteArray = new PosByteArray();
        int n2 = POIGeneralAPI.getDefault().getPrintMode(posByteArray);
        if (n2 == 0 && posByteArray.buffer != null) {
            this.printMode = PosUtils.bytesToHexString(posByteArray.buffer);
        }
        PosLog.i(TAG, "POIPrinterManager printMode:" + this.printMode);
        this.printer = PosPrinter.open(this.openId);
        this.printerLayout = new PrinterLayout(this.context, this.printMode);
        this.status = 0;
        this.isReceiver = true;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.pos.action.RECONNECT_POS_SERVICE");
        this.context.registerReceiver(this.broadcastReceiver, intentFilter);
    }

    public void close() {
        if (this.isReceiver) {
            this.context.unregisterReceiver(this.broadcastReceiver);
            this.isReceiver = false;
        }
        if (this.printer != null) {
            this.printer.release();
            this.printer = null;
        }
        this.printerLayout = null;
        this.status = 4;
    }

    public int getPrinterState() {
        if (this.printer == null || this.status == 4) {
            this.status = 4;
            return this.status;
        }
        PosPrintStateInfo posPrintStateInfo = new PosPrintStateInfo();
        this.printer.getPrintStateInfo(posPrintStateInfo);
        switch (posPrintStateInfo.mState) {
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return this.status;
    }

    public void setPrintType(String string) {
        SystemProperties.set((String)"sys.pos.print.type", (String)string);
    }

    public void setPrintGray(int n) {
        if (this.printer == null) {
            return;
        }
        PosPrinter.Parameters parameters = this.printer.getParameters();
        parameters.setPrintGray(n);
        this.printer.setParameters(parameters);
    }

    public void setPrintRed(int n) {
        if (this.printer == null) {
            return;
        }
        PosPrinter.Parameters parameters = this.printer.getParameters();
        parameters.setPrintRed(n);
        this.printer.setParameters(parameters);
    }

    public void setPrintFont(String string) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        this.printerLayout.setFontPath(string);
    }

    public void setPrintFontAssets(String string) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        this.printerLayout.setFontAsset(string);
    }

    public String getFont() {
        return this.printerLayout.getFontPath();
    }

    public void setLineSpace(int n) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        this.printerLayout.setLineSpace(n);
    }

    public void cleanCache() {
        if (this.printer != null) {
            this.printer.cleanCache();
        }
        if (this.printerLayout != null) {
            this.printerLayout.removeAllViews();
            this.printerLayout.setLineSpace(0);
            this.printerLayout.setBottomSpace(0);
        }
    }

    public void addPrintLine(PrintLine printLine) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        switch (printLine.getType()) {
            case 0: {
                this.printerLayout.addText((TextPrintLine)printLine);
                break;
            }
            case 1: {
                this.printerLayout.addBitmap((BitmapPrintLine)printLine);
                break;
            }
        }
    }

    public void addPrintLine(List<TextPrintLine> list) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        this.printerLayout.addText(list, false);
    }

    public void addLinearPrintLine(List<TextPrintLine> list) {
        if (this.printerLayout == null) {
            this.printerLayout = new PrinterLayout(this.context);
        }
        if (null != list && list.size() > 0) {
            this.printerLayout.addText(list, true);
        }
    }

    public void addBlankView(int n) {
        this.printerLayout.addBlankView(n);
    }

    public void setBlankViewPixel(int n) {
        this.printerLayout.setBlankViewPixel(n);
    }

    public void beginPrint(IPrinterListener iPrinterListener) {
        this.listener = iPrinterListener;
        if (this.listener == null || this.printer == null || this.printerLayout == null) {
            if (this.listener != null) {
                this.listener.onError(-1, "Printer init failed.");
            }
            return;
        }
        if (this.isSleep()) {
            this.listener.onError(-2, "In the case of a lock screen, printing is not support.");
            return;
        }
        if (this.status != 0) {
            this.listener.onError(-2, "Printer status failed.");
            return;
        }
        this.printerLayout.viewToBitmap(this.viewToBitmapListener);
    }

    public void lineWrap(int n) {
        if (!this.isSleep() && this.printer != null) {
            this.printer.setPrintCtrlFeed((int)((double)(n * 8) * 3.84));
        }
    }

    public void lineWrapPixels(int n) {
        if (!this.isSleep() && this.printer != null) {
            this.printer.setPrintCtrlFeed(n * this.linePixels);
        }
    }

    public void setLineWrapPixels(int n) {
        this.linePixels = n;
    }

    public double getPrinterLength() {
        return this.div(this.printer.getTotalPixLineCnt());
    }

    public double getBeforePrinterLength() {
        return this.div(this.printer.getBeforePixLineCnt());
    }

    private double div(double d) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(8.0));
        return bigDecimal.divide(bigDecimal2, 2, 4).doubleValue();
    }

    private byte[] bitmapToByteArray(Bitmap bitmap) {
        int n = 127;
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        byte[] byArray = new byte[n4 / 8];
        bitmap.getPixels(nArray, 0, n2, 0, 0, n2, n3);
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray[i];
            int n6 = (n5 & 0xFF0000) >> 16;
            int n7 = (n5 & 0xFF00) >> 8;
            int n8 = n5 & 0xFF;
            int n9 = (n6 + n7 + n8) / 3;
            byArray[i / 8] = n9 <= n ? (byte)(byArray[i / 8] | 1 << 7 - i % 8) : (byte)(byArray[i / 8] & ~(1 << 7 - i % 8));
        }
        return byArray;
    }

    private byte[] bitmapToByteArrayTwoColor(Bitmap bitmap) {
        try {
            int n;
            int n2 = bitmap.getWidth();
            int n3 = bitmap.getHeight();
            int n4 = (n2 + 7) / 8 * 8;
            int n5 = n4 / 8;
            int n6 = n3;
            int n7 = n5 * n6;
            byte[] byArray = new byte[n7];
            byte[] byArray2 = new byte[n7 * 2];
            for (n = 0; n < n7; ++n) {
                byArray[n] = 0;
            }
            for (n = 0; n < byArray2.length; ++n) {
                byArray2[n] = 0;
            }
            int n8 = 0;
            int n9 = 0;
            for (n = 0; n < n3; ++n) {
                int[] nArray = new int[n2];
                bitmap.getPixels(nArray, 0, n2, 0, n, n2, 1);
                int n10 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n11 = nArray[i];
                    if (n10 == 4) {
                        n10 = 0;
                    }
                    if (n9 == 4) {
                        n9 = 0;
                        ++n8;
                    }
                    int n12 = 1;
                    n12 <<= 7 - (n10 + n10);
                    int n13 = 0;
                    n13 <<= 7 - (n10 + n10);
                    int n14 = 1;
                    n14 <<= 7 - (n10 + (n10 + 1));
                    int n15 = 0;
                    n15 <<= 7 - (n10 + (n10 + 1));
                    int n16 = 0;
                    n16 <<= 7 - (n10 + (n10 + 1));
                    int n17 = Color.red((int)n11);
                    int n18 = Color.green((int)n11);
                    int n19 = Color.blue((int)n11);
                    switch (this.JudgeColor(n17, n18, n19)) {
                        case 0: {
                            byArray2[n8] = (byte)(byArray2[n8] | n12);
                            byArray2[n8] = (byte)(byArray2[n8] | n15);
                            break;
                        }
                        case 1: {
                            byArray2[n8] = (byte)(byArray2[n8] | n12);
                            byArray2[n8] = (byte)(byArray2[n8] | n14);
                            break;
                        }
                        default: {
                            byArray2[n8] = (byte)(byArray2[n8] | n13);
                            byArray2[n8] = (byte)(byArray2[n8] | n16);
                        }
                    }
                    ++n10;
                    ++n9;
                }
            }
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private int JudgeColor(int n, int n2, int n3) {
        if (n > 240 && n2 > 240 && n3 > 240) {
            return 9;
        }
        if (n > 240 && n2 < 240 && n3 < 240) {
            return 0;
        }
        if (n < 240 && n2 < 240 && n3 < 240) {
            return 1;
        }
        return 9;
    }

    private boolean isSleep() {
        return !this.isScreenOn();
    }

    private boolean isScreenOn() {
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        return powerManager.isInteractive();
    }

    public static interface IPrinterListener {
        public void onStart();

        public void onFinish();

        public void onError(int var1, String var2);
    }

    class ViewToBitmapListener
    implements PrinterLayout.ViewToBitmapListener {
        ViewToBitmapListener() {
        }

        @Override
        public void success(Bitmap bitmap) {
            if (bitmap == null || POIPrinterManager.this.printer == null) {
                this.failure();
                return;
            }
            byte[] byArray = POIPrinterManager.this.printMode.equals("01") ? POIPrinterManager.this.bitmapToByteArrayTwoColor(bitmap) : POIPrinterManager.this.bitmapToByteArray(bitmap);
            POIPrinterManager.this.printer.setOnEventListener(POIPrinterManager.this.eventListener);
            POIPrinterManager.this.printer.addRawDataToCache(byArray);
            POIPrinterManager.this.printer.print();
        }

        @Override
        public void failure() {
            POIPrinterManager.this.listener.onError(-2, "Printer bitmap failed.");
        }
    }
}

