/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.printer;

import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.pos.sdk.PosConstants;
import com.pos.sdk.PosLog;
import com.pos.sdk.printer.IPosPrinter;
import com.pos.sdk.printer.IPosPrinterListener;
import com.pos.sdk.printer.IPosPrinterService;
import com.pos.sdk.printer.PosPrintData;
import com.pos.sdk.printer.PosPrintStateInfo;
import com.pos.sdk.printer.PosPrinterInfo;
import com.pos.sdk.utils.PosParameters;
import com.pos.sdk.utils.PosUtils;
import java.util.ArrayList;
import java.util.List;

public class PosPrinter {
    private static final String TAG = "PosPrinter";
    private static final boolean DEBUG = PosConstants.DEBUG;
    public static final int PRINTER_TYPE_THERMO = 1;
    public static final int PRINTER_TYPE_OPTICAL = 2;
    public static final int PRINTER_TYPE_DIGITAL = 3;
    public static final int PRINTER_TYPE_BLUETOOTH = 4;
    public static final int PRINTER_TYPE_DOCK = 5;
    public static final int PRINTER_STATE_NONE = 0;
    public static final int PRINTER_STATE_IDLE = 1;
    public static final int PRINTER_STATE_CACHING = 2;
    public static final int PRINTER_STATE_PRINTING = 3;
    public static final int PRINTER_STATE_NO_PAPER = 4;
    public static final int PRINTER_STATE_TEMP_OVERHEAT = 5;
    public static final int PRINTER_STATE_ERROR = 6;
    public static final int PRINTER_STATE_DISCONNECTED = 7;
    public static final int PRINTER_STATE_NO_BATTERY = 8;
    public static final int PRINTER_INFO_STATE_CHANGED = 1;
    public static final int PRINTER_ERROR_OVER_HEAT = 1;
    public static final int PRINTER_ERROR_NO_PAPER = 2;
    public static final int PRINTER_ERROR_CACHE_OVERLOAD = 3;
    public static final int PRINTER_ERROR_STATE = 4;
    public static final int PRINTER_ERROR_NO_BLACKMARK = 5;
    public static final int PRINTER_ERROR_NO_BATTERY = 6;
    public static final int PRINTER_MSG_ONINFO = 1;
    public static final int PRINTER_MSG_ONERROR = 2;
    public static final int PRINTER_MSG_CURSOR_CHANGED = 3;
    private IBinder mICallBack;
    private IPosPrinter mPosPrinter;
    private PrinterListener mPrinterListener;
    private EventListener mEventListener;
    private EventHandler mEventHandler;

    public static final int getNumberOfPrinters() {
        try {
            return PosPrinter.getService().getNumberOfPrinters();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public static void getPrinterInfo(int n, PosPrinterInfo posPrinterInfo) {
        try {
            PosPrinter.getService().getPrinterInfo(n, posPrinterInfo);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static PosPrintStateInfo getPrintStateInfo(int n) {
        try {
            return PosPrinter.getService().getPrintStateInfo(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public static PosPrinter open(int n) {
        return new PosPrinter(n);
    }

    public static PosPrinter open() {
        int n = PosPrinter.getNumberOfPrinters();
        if (n > 0) {
            return new PosPrinter(0);
        }
        return null;
    }

    private static IPosPrinterService getService() {
        return IPosPrinterService.Stub.asInterface(ServiceManager.getService((String)"com.pos.service.printer"));
    }

    private PosPrinter(int n) {
        try {
            this.mICallBack = new Binder();
            this.mPosPrinter = PosPrinter.getService().createPrinter(n, this.mICallBack);
            Looper looper = Looper.myLooper();
            this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
            this.mPrinterListener = new PrinterListener();
            this.mPosPrinter.registerListener(this.mPrinterListener);
        }
        catch (RemoteException remoteException) {
            this.mPosPrinter = null;
        }
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        PosUtils.checkVersion(TAG);
    }

    public void release() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            this.mPosPrinter.unregisterListener(this.mPrinterListener);
            this.mPosPrinter.release();
            PosPrinter.getService().removePrinter(this.mPosPrinter, this.mICallBack);
            this.mPosPrinter = null;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setParameters(Parameters parameters) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            this.mPosPrinter.setParameters(parameters.flatten());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public Parameters getParameters() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            Parameters parameters = new Parameters();
            String string = this.mPosPrinter.getParameters();
            parameters.unflatten(string);
            return parameters;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public void getPrintStateInfo(PosPrintStateInfo posPrintStateInfo) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            this.mPosPrinter.getPrintStateInfo(posPrintStateInfo);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    @Deprecated
    public int setCursor(int n, int n2) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.setCursor(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int addTextToCache(String string, int n, int n2) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addTextToCache(string, n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int addTextToCurCache(String string) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addTextToCurCache(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int addBmpToCache(String string, int n, int n2) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addBmpToCache(string, n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int addBmpToCurCache(String string) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addBmpToCurCache(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int cleanCache() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.cleanCache();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int print() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.print();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int printText(String string) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.printText(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int printBmp(String string) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.printBmp(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int setPrintCtrlFeed(int n) {
        return this.setPrintCtrlFeed(n, 0, 0);
    }

    public int setPrintCtrlFeed(int n, int n2) {
        return this.setPrintCtrlFeed(n, n2, 0);
    }

    public int setPrintCtrlFeed(int n, int n2, int n3) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.setPrintCtrlFeed(n, n2, n3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int addRawDataToCache(byte[] byArray) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addRawDataToCache(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int printRawData(byte[] byArray) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.printRawData(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getBeforePixLineCnt() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.getBeforePixLineCnt();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int getTotalPixLineCnt() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.getTotalPixLineCnt();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public long getCurrentEndPrintTime() {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.getCurrentEndPrintTime();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1L;
        }
    }

    public int addBitmapToCache(Bitmap bitmap) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.addBitmapToCache(bitmap);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int printBitmap(Bitmap bitmap) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        try {
            return this.mPosPrinter.printBitmap(bitmap);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int addBatchDataToCache(List<PrintData> list) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        if (list == null || list.size() == 0) {
            PosLog.e(TAG, "addBatchDataToCache:: Invalid parameters!");
            return -1;
        }
        if (DEBUG) {
            PosLog.d(TAG, "addBatchDataToCache:: dataList size= " + list.size());
        }
        try {
            ArrayList<PosPrintData> arrayList = new ArrayList<PosPrintData>();
            PosPrintData posPrintData = null;
            for (PrintData printData : list) {
                posPrintData = new PosPrintData();
                if (printData.parameter != null) {
                    posPrintData.mParameters = printData.parameter.flatten();
                }
                posPrintData.mText = printData.textContent;
                posPrintData.mImagePath = printData.imagePath;
                posPrintData.mBitmap = printData.bitmap;
                arrayList.add(posPrintData);
            }
            return this.mPosPrinter.addBatchDataToCache(arrayList);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int printBatchData(List<PrintData> list) {
        if (this.mPosPrinter == null) {
            throw new NullPointerException("mPosPrinter is null!!");
        }
        if (list == null || list.size() == 0) {
            PosLog.e(TAG, "printBatchData:: Invalid parameters!");
            return -1;
        }
        try {
            ArrayList<PosPrintData> arrayList = new ArrayList<PosPrintData>();
            PosPrintData posPrintData = null;
            for (PrintData printData : list) {
                posPrintData = new PosPrintData();
                if (printData.parameter != null) {
                    posPrintData.mParameters = printData.parameter.flatten();
                }
                posPrintData.mText = printData.textContent;
                posPrintData.mImagePath = printData.imagePath;
                if (printData.bitmap == null) continue;
                posPrintData.mBitmap = Bitmap.createBitmap((Bitmap)printData.bitmap);
            }
            return this.mPosPrinter.printBatchData(arrayList);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public void setOnEventListener(EventListener eventListener) {
        this.mEventListener = eventListener;
    }

    public final class PrintData {
        public Parameters parameter;
        public String textContent;
        public String imagePath;
        public Bitmap bitmap;

        public PrintData(boolean bl, String string) {
            this(null, bl ? string : null, !bl ? string : null, null);
        }

        public PrintData(Parameters parameters, boolean bl, String string) {
            this(parameters, bl ? string : null, !bl ? string : null, null);
        }

        public PrintData(Bitmap bitmap) {
            this(null, null, null, bitmap);
        }

        public PrintData(Parameters parameters, Bitmap bitmap) {
            this(parameters, null, null, bitmap);
        }

        public PrintData(Parameters parameters, String string, String string2, Bitmap bitmap) {
            this.parameter = parameters;
            this.textContent = string;
            this.imagePath = string2;
            this.bitmap = bitmap;
        }
    }

    public class Parameters
    extends PosParameters {
        public static final String KEY_FONT_NAME = "font-name";
        public static final String KEY_FONT_SIZE = "font-size";
        public static final String KEY_FONT_EFFECT = "font-effect";
        public static final String KEY_FONT_FLAGS = "font-flags";
        public static final String KEY_PRINT_GRAY = "print-gray";
        public static final String KEY_PRINT_RED = "print-red";
        public static final String KEY_PRINT_ALIGN = "print-align";
        public static final String KEY_PRINT_HEATPOINT = "print-heatpoint";
        public static final String KEY_PRINT_STEP = "print-step";
        public static final String KEY_LINE_SPACE = "line-space";
        public static final String KEY_CHAR_SPACE = "char-space";
        public static final String KEY_DETECT_BLACKMARK = "detect-blackmark";
        public static final String KEY_DETECT_BLACKMARK_STEP = "detect-blackmark-step";
        public static final String KEY_PRINT_STEP_BY_KEYSTOKE = "print-step-by-keystoke";
        public static final String KEY_PRINT_APPEND_TEXT = "print-append-text";
        public static final String KEY_FONT_SCALE = "font-scale";
        public static final int ALIGH_LEFT = 0;
        public static final int ALIGH_CENTER = 1;
        public static final int ALIGH_RIGHT = 2;
        public static final int EFFECT_NONE = 0;
        public static final int EFFECT_BOLD = 1;
        public static final int EFFECT_LEAN = 2;
        public static final int EFFECT_BOLD_LEAN = 3;

        private Parameters() {
        }

        public void setFontName(String string) {
            this.set(KEY_FONT_NAME, string);
        }

        public String getFontName() {
            return this.get(KEY_FONT_NAME);
        }

        public void setFontSize(int n) {
            this.set(KEY_FONT_SIZE, n);
        }

        public int getFontSize() {
            return this.getInt(KEY_FONT_SIZE);
        }

        public void setFontEffet(int n) {
            this.set(KEY_FONT_EFFECT, n);
        }

        public int getFontEffet() {
            return this.getInt(KEY_FONT_EFFECT);
        }

        public void setFontFlags(int n) {
            this.set(KEY_FONT_FLAGS, n);
        }

        public int getFontFlags() {
            return this.getInt(KEY_FONT_FLAGS);
        }

        public void setPrintGray(int n) {
            this.set(KEY_PRINT_GRAY, n);
        }

        public int getPrintGray() {
            return this.getInt(KEY_PRINT_GRAY);
        }

        public void setPrintRed(int n) {
            this.set(KEY_PRINT_RED, n);
        }

        public int getPrintRed() {
            return this.getInt(KEY_PRINT_RED);
        }

        public void setPrintAlign(int n) {
            this.set(KEY_PRINT_ALIGN, n);
        }

        public int getPrintAlign() {
            return this.getInt(KEY_PRINT_ALIGN);
        }

        public void setPrintHeatPoint(int n) {
            this.set(KEY_PRINT_HEATPOINT, n);
        }

        public int getPrintHeatPoint() {
            return this.getInt(KEY_PRINT_HEATPOINT);
        }

        public void setPrintStep(int n) {
            this.set(KEY_PRINT_STEP, n);
        }

        public int getPrintStep() {
            return this.getInt(KEY_PRINT_STEP);
        }

        public void setLineSpace(int n) {
            this.set(KEY_LINE_SPACE, n);
        }

        public int getLineSpace() {
            return this.getInt(KEY_LINE_SPACE);
        }

        public void setCharSpace(int n) {
            this.set(KEY_CHAR_SPACE, n);
        }

        public int getCharSpace() {
            return this.getInt(KEY_CHAR_SPACE);
        }

        @Deprecated
        public void setDetectBlackMark(int n, int n2) {
            this.set(KEY_DETECT_BLACKMARK, n);
            this.set(KEY_DETECT_BLACKMARK_STEP, n2);
        }

        @Deprecated
        public int getDetectBlackMark() {
            return this.getInt(KEY_DETECT_BLACKMARK);
        }

        @Deprecated
        public int getDetectBlackMarkStep() {
            return this.getInt(KEY_DETECT_BLACKMARK_STEP);
        }

        public void setPrintStepByKeyStroke(int n) {
            this.set(KEY_PRINT_STEP_BY_KEYSTOKE, n);
        }

        public int getPrintStepByKeyStroke() {
            return this.getInt(KEY_PRINT_STEP_BY_KEYSTOKE);
        }

        public void setPrintAppendText(boolean bl) {
            this.set(KEY_PRINT_APPEND_TEXT, bl);
        }

        public boolean getPrintAppendText() {
            return this.getBoolean(KEY_PRINT_APPEND_TEXT);
        }

        public void setFontScale(float f) {
            this.set(KEY_FONT_SCALE, f);
        }

        public float getFontScale() {
            return this.getFloat(KEY_FONT_SCALE);
        }
    }

    public static interface EventListener {
        public void onInfo(PosPrinter var1, int var2, int var3);

        public void onError(PosPrinter var1, int var2, int var3);

        public void onCursorChanged(PosPrinter var1, int var2, int var3, int var4, int var5);
    }

    private class PrinterListener
    extends IPosPrinterListener.Stub {
        private PrinterListener() {
        }

        @Override
        public void onInfo(int n, int n2) {
            if (PosPrinter.this.mEventHandler != null) {
                if (PosPrinter.this.mEventHandler.hasMessages(1)) {
                    PosPrinter.this.mEventHandler.removeMessages(1);
                }
                PosPrinter.this.mEventHandler.sendMessage(PosPrinter.this.mEventHandler.obtainMessage(1, n, n2));
            }
        }

        @Override
        public void onError(int n, int n2) {
            if (PosPrinter.this.mEventHandler != null) {
                if (PosPrinter.this.mEventHandler.hasMessages(2)) {
                    PosPrinter.this.mEventHandler.removeMessages(2);
                }
                PosPrinter.this.mEventHandler.sendMessage(PosPrinter.this.mEventHandler.obtainMessage(2, n, n2));
            }
        }

        @Override
        public void onCursorChanged(int n, int n2, int n3, int n4) {
            if (PosPrinter.this.mEventHandler != null) {
                int n5 = 0;
                byte[] byArray = new byte[16];
                System.arraycopy(byArray, n5, PosUtils.intToBytesBe(n), 0, 4);
                System.arraycopy(byArray, n5 += 4, PosUtils.intToBytesBe(n2), 0, 4);
                System.arraycopy(byArray, n5 += 4, PosUtils.intToBytesBe(n3), 0, 4);
                System.arraycopy(byArray, n5 += 4, PosUtils.intToBytesBe(n4), 0, 4);
                n5 += 4;
                if (PosPrinter.this.mEventHandler.hasMessages(3)) {
                    PosPrinter.this.mEventHandler.removeMessages(3);
                }
                PosPrinter.this.mEventHandler.sendMessage(PosPrinter.this.mEventHandler.obtainMessage(3, byArray));
            }
        }
    }

    private class EventHandler
    extends Handler {
        private PosPrinter mPrinter;

        public EventHandler(PosPrinter posPrinter2, Looper looper) {
            super(looper);
            this.mPrinter = posPrinter2;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (PosPrinter.this.mEventListener == null) break;
                    PosPrinter.this.mEventListener.onInfo(this.mPrinter, message.arg1, message.arg2);
                    break;
                }
                case 2: {
                    if (PosPrinter.this.mEventListener == null) break;
                    PosPrinter.this.mEventListener.onError(this.mPrinter, message.arg1, message.arg2);
                    break;
                }
                case 3: {
                    if (PosPrinter.this.mEventListener == null) break;
                    int n = 0;
                    byte[] byArray = (byte[])message.obj;
                    int n2 = PosUtils.bytesToIntBe(byArray, n, 4);
                    int n3 = PosUtils.bytesToIntBe(byArray, n += 4, 4);
                    int n4 = PosUtils.bytesToIntBe(byArray, n += 4, 4);
                    int n5 = PosUtils.bytesToIntBe(byArray, n += 4, 4);
                    PosPrinter.this.mEventListener.onCursorChanged(this.mPrinter, n2, n3, n4, n5);
                }
            }
        }
    }
}

