/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.printer.models;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.pos.sdk.printer.models.BitmapPrintLine;
import com.pos.sdk.printer.models.TextPrintLine;
import java.util.Hashtable;
import java.util.List;

public class PrinterLayout
extends LinearLayout {
    private static final int BITMAP_WIDTH = 384;
    private static final int BITMAP_HEIGHT = 0;
    private static final int BITMAP_MAX_WIDTH = 384;
    private static final int BITMAP_MAX_HEIGHT = 100000;
    private int lineSpace;
    private int bottomSpace;
    private int bitmapMaxWidth;
    private int bitmapMaxHeight;
    private Context context;
    private LinearLayout.LayoutParams layoutParams;
    private String fontPath;
    private int blankViewPixel = 30;
    private String printMode = "00";
    private static Hashtable<String, Typeface> fontCache = new Hashtable();

    public PrinterLayout(Context context) {
        this(context, null, "00");
    }

    public PrinterLayout(Context context, String string) {
        this(context, null, 0, string);
    }

    public PrinterLayout(Context context, AttributeSet attributeSet, String string) {
        this(context, attributeSet, 0, "00");
    }

    public PrinterLayout(Context context, AttributeSet attributeSet, int n, String string) {
        super(context, attributeSet, n);
        this.context = context;
        this.bitmapMaxWidth = 384;
        this.bitmapMaxHeight = 100000;
        this.setOrientation(1);
        this.layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.printMode = string;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        super.setPadding(n, n2, n3, n4 + this.bottomSpace);
    }

    public Typeface getFont() {
        if (fontCache.isEmpty() || this.fontPath == null) {
            return Typeface.DEFAULT;
        }
        Typeface typeface = fontCache.get(this.fontPath);
        if (typeface != null) {
            return typeface;
        }
        return Typeface.DEFAULT;
    }

    public void setFontPath(String string) {
        this.fontPath = string;
        Typeface typeface = fontCache.get(string);
        if (typeface == null) {
            try {
                typeface = Typeface.createFromFile((String)string);
            }
            catch (Exception exception) {
                this.fontPath = null;
                return;
            }
            fontCache.put(string, typeface);
        }
    }

    public void setFontAsset(String string) {
        this.fontPath = string;
        Typeface typeface = fontCache.get(string);
        if (typeface == null) {
            try {
                AssetManager assetManager = this.context.getAssets();
                typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)("fonts/" + string));
            }
            catch (Exception exception) {
                this.fontPath = null;
                return;
            }
            fontCache.put(string, typeface);
        }
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public void setLineSpace(int n) {
        this.lineSpace = n;
    }

    public void setBlankViewPixel(int n) {
        this.blankViewPixel = n;
    }

    public int getBottomSpace() {
        return this.bottomSpace;
    }

    public void setBottomSpace(int n) {
        this.bottomSpace = n;
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom() + n);
    }

    public int getBitmapMaxWidth() {
        return this.bitmapMaxWidth;
    }

    public void setBitmapMaxWidth(int n) {
        this.bitmapMaxWidth = n;
    }

    public int getBitmapMaxHeight() {
        return this.bitmapMaxHeight;
    }

    public void setBitmapMaxHeight(int n) {
        this.bitmapMaxHeight = n;
    }

    public void addView(View view) {
        this.addView(view, (ViewGroup.LayoutParams)this.layoutParams);
    }

    public void addTextView(TextView textView) {
        this.addView((View)textView, (ViewGroup.LayoutParams)this.layoutParams);
    }

    public void addImageView(ImageView imageView) {
        this.addView((View)imageView, (ViewGroup.LayoutParams)this.layoutParams);
    }

    public void addText(TextPrintLine textPrintLine) {
        this.addView(this.getTextPrintLine(textPrintLine), (ViewGroup.LayoutParams)this.layoutParams);
    }

    public void addText(List<TextPrintLine> list, boolean bl) {
        if (bl) {
            LinearLayout linearLayout = new LinearLayout(this.context);
            linearLayout.setOrientation(0);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            for (TextPrintLine textPrintLine : list) {
                linearLayout.addView(this.getTextPrintLine(textPrintLine), (ViewGroup.LayoutParams)layoutParams);
            }
            this.addView((View)linearLayout, (ViewGroup.LayoutParams)this.layoutParams);
        } else {
            RelativeLayout relativeLayout = new RelativeLayout(this.context);
            for (TextPrintLine textPrintLine : list) {
                relativeLayout.addView(this.getTextPrintLine(textPrintLine), (ViewGroup.LayoutParams)this.layoutParams);
            }
            this.addView((View)relativeLayout, (ViewGroup.LayoutParams)this.layoutParams);
        }
    }

    public void addBlankView(int n) {
        View view = new View(this.context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, n * this.blankViewPixel);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void addBitmap(BitmapPrintLine bitmapPrintLine) {
        this.addView(this.getBitmapPrintLine(bitmapPrintLine), (ViewGroup.LayoutParams)this.layoutParams);
    }

    private View getTextPrintLine(TextPrintLine textPrintLine) {
        TextView textView = new TextView(this.context);
        textView.setPadding(textView.getPaddingLeft() + textPrintLine.getPaddingLeft(), textView.getPaddingTop(), textView.getPaddingRight(), textView.getPaddingBottom() + this.lineSpace);
        switch (textPrintLine.getPosition()) {
            case 0: {
                textView.setGravity(0x800003);
                break;
            }
            case 2: {
                textView.setGravity(0x800005);
                break;
            }
            default: {
                textView.setGravity(17);
            }
        }
        if (textPrintLine.isInvert()) {
            textView.setTextColor(-1);
            textView.setBackgroundColor(-16777216);
        } else {
            textView.setTextColor(-16777216);
            textView.setBackgroundColor(0);
        }
        if (textPrintLine.isMirrorInvertY()) {
            textView.setRotationY(180.0f);
        }
        textView.setTextSize(0, textPrintLine.getSize());
        textView.setLineSpacing((float)this.lineSpace, 1.0f);
        textView.getPaint().setAntiAlias(false);
        textView.setPaintFlags(256);
        Typeface typeface = null;
        if (textPrintLine.getPrintFont() != null && !textPrintLine.getPrintFont().isEmpty()) {
            try {
                AssetManager assetManager = this.context.getAssets();
                typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)("fonts/" + textPrintLine.getPrintFont()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (typeface == null) {
            typeface = this.getFont();
        }
        if (textPrintLine.isBold() && textPrintLine.isItalic()) {
            textView.setTypeface(typeface, 3);
        } else if (textPrintLine.isBold()) {
            textView.setTypeface(typeface, 1);
        } else if (textPrintLine.isItalic()) {
            textView.setTypeface(typeface, 2);
        } else {
            textView.setTypeface(typeface, 0);
        }
        if (textPrintLine.getContent() != null) {
            textView.setText((CharSequence)textPrintLine.getContent());
        }
        textView.setLetterSpacing(textPrintLine.getLetterSpacing());
        if (!((double)Math.abs(textPrintLine.getWordSpacing()) < 0.001)) {
            textView.getPaint().setWordSpacing(textPrintLine.getWordSpacing());
        }
        if (textPrintLine.getTextScaleX() > 0.0f) {
            textView.setTextScaleX(textPrintLine.getTextScaleX());
        }
        if (textPrintLine.isUnderLineText()) {
            textView.getPaint().setFlags(8);
            textView.getPaint().setAntiAlias(true);
        }
        return textView;
    }

    private View getBitmapPrintLine(BitmapPrintLine bitmapPrintLine) {
        ImageView imageView = new ImageView(this.context);
        imageView.setPadding(imageView.getPaddingLeft() + bitmapPrintLine.getPaddingLeft(), imageView.getPaddingTop(), imageView.getPaddingRight(), imageView.getPaddingBottom() + this.lineSpace);
        switch (bitmapPrintLine.getPosition()) {
            case 0: {
                imageView.setScaleType(ImageView.ScaleType.FIT_START);
                break;
            }
            case 2: {
                imageView.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            default: {
                imageView.setScaleType(ImageView.ScaleType.CENTER);
            }
        }
        if (bitmapPrintLine.getBitmap() != null) {
            int n = bitmapPrintLine.getBitmap().getWidth();
            int n2 = bitmapPrintLine.getBitmap().getHeight();
            if (n > this.bitmapMaxWidth || n2 > this.bitmapMaxHeight) {
                Bitmap bitmap = this.scaleBitmap(bitmapPrintLine.getBitmap());
                imageView.setImageBitmap(bitmap);
            } else {
                imageView.setImageBitmap(bitmapPrintLine.getBitmap());
            }
        }
        if (this.printMode.equals("00")) {
            ColorMatrix colorMatrix = new ColorMatrix();
            colorMatrix.setSaturation(0.0f);
            ColorMatrixColorFilter colorMatrixColorFilter = new ColorMatrixColorFilter(colorMatrix);
            imageView.setColorFilter((ColorFilter)colorMatrixColorFilter);
        }
        return imageView;
    }

    private Bitmap scaleBitmap(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        float f = 384.0f / (float)n;
        float f2 = 0.0f / (float)n2;
        float f3 = Math.max(f, f2);
        Matrix matrix = new Matrix();
        matrix.postScale(f3, f3);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)false);
    }

    public void viewToBitmap(ViewToBitmapListener viewToBitmapListener) {
        int n = View.MeasureSpec.makeMeasureSpec((int)384, (int)0x40000000);
        int n2 = View.MeasureSpec.makeMeasureSpec((int)100000, (int)Integer.MIN_VALUE);
        this.measure(n, n2);
        this.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Bitmap bitmap = this.printMode.equals("00") ? Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-1);
        this.invalidate();
        this.draw(canvas);
        viewToBitmapListener.success(bitmap);
    }

    public static interface ViewToBitmapListener {
        public void success(Bitmap var1);

        public void failure();
    }
}

