/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.security;

import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import com.pos.sdk.PosConstants;
import com.pos.sdk.PosLog;
import com.pos.sdk.security.IPosSecurity;
import com.pos.sdk.security.IPosSecurityListener;
import com.pos.sdk.security.PedKcvInfo;
import com.pos.sdk.security.PedKeyInfo;
import com.pos.sdk.security.PedRsaPinKey;
import com.pos.sdk.servicemanager.POIServiceManager;
import com.pos.sdk.utils.PosByteArray;
import com.pos.sdk.utils.PosUtils;
import java.util.ArrayList;

public class POIHsmManage {
    private static final String TAG = "POIHsmManage";
    private static final boolean DEBUG = PosConstants.DEBUG;
    public static final int PED_TLK = 1;
    public static final int PED_TMK = 2;
    public static final int PED_TPK = 3;
    public static final int PED_TAK = 4;
    public static final int PED_TDK = 5;
    public static final int PED_TEK = 6;
    public static final int PED_TTK = 9;
    public static final int PED_TIK = 16;
    public static final int PED_TRK = 17;
    public static final int PED_DUKPT_TYPE_MAC = 0;
    public static final int PED_DUKPT_TYPE_DATA_REQUEST = 1;
    public static final int PED_DUKPT_TYPE_DATA_RESPONSE = 2;
    public static final int PED_DUKPT_TYPE_PIN = 3;
    public static final int PED_CALC_DES_MODE_ECB_DEC = 0;
    public static final int PED_CALC_DES_MODE_ECB_ENC = 1;
    public static final int PED_CALC_DES_MODE_CBC_DEC = 2;
    public static final int PED_CALC_DES_MODE_CBC_ENC = 3;
    public static final int PED_CALC_DES_MODE_AES_ECB_DEC = 16;
    public static final int PED_CALC_DES_MODE_AES_ECB_ENC = 17;
    public static final int PED_CALC_DES_MODE_AES_CBC_DEC = 18;
    public static final int PED_CALC_DES_MODE_AES_CBC_ENC = 19;
    public static final int PED_CALC_DES_MODE_SM4_ECB_DEC = 32;
    public static final int PED_CALC_DES_MODE_SM4_ECB_ENC = 33;
    public static final int PED_CALC_DES_MODE_SM4_CBC_DEC = 34;
    public static final int PED_CALC_DES_MODE_SM4_CBC_ENC = 35;
    public static final int PED_CALC_RSA_MODE_NO_PADDING = 0;
    public static final int PED_CALC_RSA_MODE_PKCS1_PADDING = 1;
    public static final int PED_CALC_RSA_MODE_OAEP_PADDING = 2;
    public static final int PED_PROTECT_TYPE_TR31 = 0;
    public static final int PED_PROTECT_TYPE_DEC = 1;
    public static final int PED_PROTECT_KEY_TYPE_MKSK = 0;
    public static final int PED_PROTECT_KEY_TYPE_DUKPT = 1;
    public static final int PED_PROTECT_KEY_TYPE_RSA = 2;
    public static final int PED_PROTECT_WRITE_TYPE_TLK = 0;
    public static final int PED_PROTECT_WRITE_TYPE_TMK = 1;
    public static final int PED_PROTECT_WRITE_TYPE_DUKPT = 2;
    public static final int PED_PINBLOCK_RET_TYPE_DEFAULT = 131;
    public static final int PED_PINBLOCK_RET_TYPE_PSAM = 146;
    public static final int PED_VERIFY_PIN_TYPE_PLAIN = 134;
    public static final int PED_VERIFY_PIN_TYPE_CIPHER = 135;
    public static final int PED_PINBLOCK_KEYBOARD_INPUT = 81;
    public static final int PED_PINBLOCK_KEYBOARD_SHOW = 85;
    public static final int PED_PINBLOCK_FETCH_MODE_TPK = 1;
    public static final int PED_PINBLOCK_FETCH_MODE_DUKPT = 2;
    public static final int PED_PINBLOCK_TPK_FMT_ISO9564_0 = 0;
    public static final int PED_PINBLOCK_TPK_FMT_ISO9564_1 = 1;
    public static final int PED_PINBLOCK_TPK_FMT_ISO9564_2 = 2;
    public static final int PED_PINBLOCK_TPK_FMT_HKEPS = 3;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_0_KSN_INC = 0;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_1_KSN_INC = 1;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_2_KSN_INC = 2;
    public static final int PED_PINBLOCK_DUKPT_FMT_HKEPS_KSN_INC = 3;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_0 = 32;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_1 = 33;
    public static final int PED_PINBLOCK_DUKPT_FMT_ISO9564_2 = 34;
    public static final int PED_PINBLOCK_DUKPT_FMT_HKEPS = 35;
    public static final int HW_SELF_CHECK_MASK_MAG = 1;
    public static final int HW_SELF_CHECK_MASK_ICC = 2;
    public static final int HW_SELF_CHECK_MASK_PICC = 4;
    public static final int HW_SELF_CHECK_MASK_FLASH = 8;
    public static final int HW_SELF_CHECK_MASK_KEY = 16;
    public static final int HW_SELF_CHECK_MASK_ALL = 255;
    public static final int PED_KEY_MANAGE_CMD_UNLOCK_TERMINAL_KEY = 128;
    public static final int PED_KEY_MANAGE_CMD_ADMIN_A_KEY = 129;
    public static final int PED_KEY_MANAGE_CMD_ADMIN_B_KEY = 130;
    public static final int PED_KEY_MANAGE_CMD_KEEP_STATE = 131;
    public static final int PED_KEY_MANAGE_CMD_UNLOCK_TERMINAL_KEY_NEW = 132;
    public static final int PED_KEY_MANAGE_CMD_ADMIN_A_KEY_NEW = 133;
    public static final int PED_KEY_MANAGE_CMD_ADMIN_B_KEY_NEW = 134;
    public static final int PED_KEY_MANAGE_ERROR_PASSWD = 65184;
    public static final int PED_KEY_MANAGE_ERROR_CHANGE_PASSWD = 65183;
    public static final int PED_KEY_MANAGE_ERROR_TRY_PASSWD_EXCEED = 65182;
    public static final int PED_WRITE_KEY_RESULT_OK = 0;
    public static final int PED_WRITE_KEY_RESULT_ERROR_EMPTY = 1;
    public static final int PED_WRITE_KEY_RESULT_ERROR_WRITE = 2;
    public static final int PED_WRITE_KEY_RESULT_ERROR_CHECK = 3;
    public static final int SP_STATUS_UNKNOW = -1;
    public static final int SP_STATUS_OK = 0;
    public static final int SP_STATUS_TRIGGERED = 1;
    public static final int SP_STATUS_LOCK = 2;
    public static final int SP_STATUS_KEY_WIPED = 3;
    public static final int PED_WRITE_KEY_TYPE_SN = 1;
    public static final int PED_WRITE_KEY_TYPE_WK = 2;
    public static final int PED_REMOTE_UNLOCK_ALG_RSA1024_SHA1 = 0;
    public static final int PED_REMOTE_UNLOCK_ALG_RSA1024_SHA256 = 1;
    public static final int PED_REMOTE_UNLOCK_ALG_RSA2048_SHA1 = 2;
    public static final int PED_REMOTE_UNLOCK_ALG_RSA2048_SHA256 = 3;
    private static final int SECURITY_MSG_ONINFO = 1;
    private static final int SECURITY_MSG_ONERROR = 2;
    private static final int SECURITY_MSG_ONKEYBOARD_SHOW = 3;
    private static final int SECURITY_MSG_ONKEYBOARD_INPUT = 4;
    private static final int SECURITY_MSG_ONPED_PINBLOCK_RET = 5;
    private static final int SECURITY_MSG_ONPED_VERIFY_PIN = 6;
    private static final int SECURITY_MSG_ONHW_SELFCHECK_RET = 7;
    private static final int SECURITY_MSG_ONHW_SENSOR_TRIGGERED = 8;
    private static final int SECURITY_MSG_ONPED_KEY_MANAGE = 9;
    private static POIHsmManage mInstance = new POIHsmManage();
    private IBinder mICallBack;
    private ArrayList<EventListener> mListeners = new ArrayList();
    private EventHandler mEventHandler;
    private SecurityListener mSecurityListener;

    private POIHsmManage() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mICallBack = new Binder();
        this.mSecurityListener = new SecurityListener();
        try {
            this.getService().registerListener(this.mSecurityListener);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        PosUtils.checkVersion(TAG);
    }

    public static POIHsmManage getDefault() {
        return mInstance;
    }

    private IPosSecurity getService() {
        return IPosSecurity.Stub.asInterface(ServiceManager.getService((String)"com.pos.service.security"));
    }

    public int PedCalDes(int n, int n2, byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        int n3 = -1;
        switch (n2) {
            case 3: {
                if (byArray2 != null && byArray != null) {
                    int n4 = byArray2.length > byArray.length ? byArray.length : byArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        int n5 = i;
                        byArray[n5] = (byte)(byArray[n5] ^ byArray2[i]);
                    }
                }
                n3 = this.PedCalDes(n, n2, byArray, posByteArray);
                break;
            }
            case 2: {
                n3 = this.PedCalDes(n, n2, byArray, posByteArray);
                if (n3 != 0 || byArray2 == null || posByteArray == null) break;
                int n6 = byArray2.length > posByteArray.len ? posByteArray.len : byArray2.length;
                for (int i = 0; i < n6; ++i) {
                    int n7 = i;
                    posByteArray.buffer[n7] = (byte)(posByteArray.buffer[n7] ^ byArray2[i]);
                }
                break;
            }
            default: {
                n3 = this.PedCalDes(n, n2, byArray, posByteArray);
            }
        }
        return n3;
    }

    public int PedCalDes(int n, int n2, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().PedCalDes(n, n2, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedCalDesPan(int n, int n2, byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        int n3 = -1;
        switch (n2) {
            case 3: {
                if (byArray2 != null && byArray != null) {
                    int n4 = byArray2.length > byArray.length ? byArray.length : byArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        int n5 = i;
                        byArray[n5] = (byte)(byArray[n5] ^ byArray2[i]);
                    }
                }
                n3 = this.PedCalDesPan(n, n2, byArray, posByteArray);
                break;
            }
            case 2: {
                n3 = this.PedCalDesPan(n, n2, byArray, posByteArray);
                if (n3 != 0 || byArray2 == null || posByteArray == null) break;
                int n6 = byArray2.length > posByteArray.len ? posByteArray.len : byArray2.length;
                for (int i = 0; i < n6; ++i) {
                    int n7 = i;
                    posByteArray.buffer[n7] = (byte)(posByteArray.buffer[n7] ^ byArray2[i]);
                }
                break;
            }
            default: {
                n3 = this.PedCalDesPan(n, n2, byArray, posByteArray);
            }
        }
        return n3;
    }

    public int PedCalDesPan(int n, int n2, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().PedCalDes(n, n2, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteKey(PedKeyInfo pedKeyInfo, PedKcvInfo pedKcvInfo) {
        try {
            return this.getService().PedWriteKey(pedKeyInfo, pedKcvInfo);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteTIK(int n, int n2, int n3, byte[] byArray, byte[] byArray2, PedKcvInfo pedKcvInfo) {
        try {
            return this.getService().PedWriteTIK(n, n2, n3, byArray, byArray2, pedKcvInfo);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetPinBlock(int n, int n2, int n3, int n4, byte[] byArray, String string) {
        try {
            return this.getService().PedGetPinBlock(n, n2, n3, n4, byArray, string, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedTestPinBlock() {
        try {
            return this.getService().PedTestPinBlock(this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetMac(int n, int n2, byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        if (byArray2 != null && byArray != null) {
            int n3 = byArray2.length > byArray.length ? byArray.length : byArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                byArray[n4] = (byte)(byArray[n4] ^ byArray2[i]);
            }
        }
        return this.PedGetMac(n, n2, byArray, posByteArray);
    }

    public int PedGetMac(int n, int n2, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().PedGetMac(n, n2, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetMacDukpt(int n, int n2, byte[] byArray, byte[] byArray2, PosByteArray posByteArray, PosByteArray posByteArray2) {
        if (byArray2 != null && byArray != null) {
            int n3 = byArray2.length > byArray.length ? byArray.length : byArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                byArray[n4] = (byte)(byArray[n4] ^ byArray2[i]);
            }
        }
        return this.PedGetMacDukpt(n, n2, byArray, posByteArray, posByteArray2);
    }

    public int PedGetMacDukpt(int n, int n2, byte[] byArray, PosByteArray posByteArray, PosByteArray posByteArray2) {
        try {
            return this.getService().PedGetMacDukpt(n, n2, byArray, posByteArray, posByteArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedVerifyPlainPin(int n, int n2, int n3, String string) {
        try {
            return this.getService().PedVerifyPlainPin(n, n2, n3, string, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedVerifyCipherPin(int n, int n2, int n3, String string, PedRsaPinKey pedRsaPinKey) {
        try {
            return this.getService().PedVerifyCipherPin(n, n2, n3, string, pedRsaPinKey, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetKcv(int n, int n2, PedKcvInfo pedKcvInfo, PosByteArray posByteArray) {
        try {
            return this.getService().PedGetKcv(n, n2, pedKcvInfo, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteKeyVar(int n, int n2, byte[] byArray) {
        try {
            return this.getService().PedWriteKeyVar(n, n2, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedSetIntervalTime(int n, int n2) {
        try {
            return this.getService().PedSetIntervalTime(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedSetKeyTag(byte[] byArray) {
        try {
            return this.getService().PedSetKeyTag(byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedErase() {
        try {
            return this.getService().PedErase();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetRsaKey(int n, int n2, int n3) {
        try {
            return this.getService().PedGetRsaKey(n, n2, n3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteRsaKey(int n, byte[] byArray, byte[] byArray2) {
        try {
            return this.getService().PedWriteRsaKey(n, byArray, byArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedReadRsaKey(int n, PosByteArray posByteArray, PosByteArray posByteArray2, PosByteArray posByteArray3) {
        try {
            return this.getService().PedReadRsaKey(n, posByteArray, posByteArray2, posByteArray3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedCalcRsa(int n, int n2, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().PedCalcRsa(n, n2, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteProtectKey(int n, int n2, int n3, byte[] byArray, int n4, int n5) {
        try {
            return this.getService().PedWriteProtectKey(n, n2, n3, byArray, n4, n5);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedDukptDes(int n, int n2, byte[] byArray, int n3, byte[] byArray2, PosByteArray posByteArray, PosByteArray posByteArray2) {
        try {
            return this.getService().PedDukptDes(n, n2, byArray, n3, byArray2, posByteArray, posByteArray2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetDukptKsn(int n, PosByteArray posByteArray) {
        try {
            return this.getService().PedGetDukptKsn(n, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedDukptIncreaseKsn(int n) {
        try {
            return this.getService().PedDukptIncreaseKsn(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetRandom(int n, PosByteArray posByteArray) {
        try {
            return this.getService().PedGetRandom(n, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetPsamPinBlock(int n, int n2, int n3, byte[] byArray, String string, byte[] byArray2) {
        try {
            return this.getService().PedGetPsamPinBlock(n, n2, n3, byArray, string, byArray2, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedKeyManage(int n) {
        try {
            return this.getService().PedKeyManage(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedCancelPinBlock() {
        try {
            return this.getService().PedCancelPinBlock(this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedSetKeyLayout(byte[] byArray, int n) {
        try {
            return this.getService().PedSetKeyLayout(byArray, n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysSensorCheck(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().SysSensorCheck(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysActSecurityFun(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().SysActSecurityFun(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysHwSelfCheck(int n) {
        try {
            return this.getService().SysHwSelfCheck(n, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public void SysSetAppServiceState(boolean bl) {
        try {
            this.getService().SysSetAppServiceState(bl, this.mICallBack);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean SysGetAppServiceState() {
        try {
            return this.getService().SysGetAppServiceState();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    public void SysSetWriteKeyResult(int n) {
        try {
            this.getService().SysSetWriteKeyResult(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int SysGetWriteKeyResult() {
        try {
            return this.getService().SysGetWriteKeyResult();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmTransmitData(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().GmTransmitData(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM2Encrypt(byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        try {
            return this.getService().GmSM2Encrypt(byArray, byArray2, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM2Decrypt(byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        try {
            return this.getService().GmSM2Decrypt(byArray, byArray2, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM2Sign(byte[] byArray, byte[] byArray2, PosByteArray posByteArray) {
        try {
            return this.getService().GmSM2Sign(byArray, byArray2, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM2Verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            return this.getService().GmSM2Verify(byArray, byArray2, byArray3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM2Digest(byte[] byArray, byte[] byArray2, byte[] byArray3, PosByteArray posByteArray) {
        try {
            return this.getService().GmSM2Digest(byArray, byArray2, byArray3, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int GmSM3Digest(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().GmSM3Digest(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public String GmGetVersion() {
        try {
            return this.getService().GmGetVersion();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int PedSetKeyEntry(String string, byte[] byArray) {
        try {
            return this.getService().PedSetKeyEntry(string, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetKeyEntry(String string, PosByteArray posByteArray) {
        try {
            return this.getService().PedGetKeyEntry(string, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysUnlock() {
        try {
            return this.getService().SysUnlock();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysRemoteUnlockReq(int n, PosByteArray posByteArray) {
        try {
            return this.getService().SysRemoteUnlockReq(n, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int SysRemoteUnlockRsp(int n, byte[] byArray) {
        try {
            return this.getService().SysRemoteUnlockRsp(n, byArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedDeleteKeyEntry(String string) {
        try {
            return this.getService().PedDeleteKeyEntry(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public String[] PedListKeyEntry(String string) {
        try {
            return this.getService().PedListKeyEntry(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public long PedGetKeyEntrySize(String string) {
        try {
            return this.getService().PedGetKeyEntrySize(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0L;
        }
    }

    public int GmGetInfo(byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().GmGetInfo(byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public void PedSetWriteKeyResult(int n, int n2) {
        try {
            this.getService().PedSetWriteKeyResult(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public int PedGetWriteKeyResult(int n) {
        try {
            return this.getService().PedGetWriteKeyResult(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public PedKeyInfo[] PedGetWriteKeyInfo() {
        try {
            return this.getService().PedGetWriteKeyInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return null;
        }
    }

    public int PedCalcDesEx(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, PosByteArray posByteArray) {
        try {
            return this.getService().PedCalcDesEx(n, byArray, byArray2, byArray3, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int KeyboardSwitchClearFunction(int n) {
        try {
            return this.getService().KeyboardSwitchClearFunction(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int KeyboardSwitchEscFunction(int n) {
        try {
            return this.getService().KeyboardSwitchEscFunction(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedGetEccKey(int n, int n2) {
        try {
            return this.getService().PedGetEccKey(n, n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedReadEccKey(int n, PosByteArray posByteArray, PosByteArray posByteArray2, PosByteArray posByteArray3, PosByteArray posByteArray4, PosByteArray posByteArray5, PosByteArray posByteArray6, PosByteArray posByteArray7, PosByteArray posByteArray8) {
        try {
            return this.getService().PedReadEccKey(n, posByteArray, posByteArray2, posByteArray3, posByteArray4, posByteArray5, posByteArray6, posByteArray7, posByteArray8);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedWriteEccKey(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        try {
            return this.getService().PedWriteEccKey(n, n2, byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public int PedCalcEcc(int n, byte[] byArray, PosByteArray posByteArray) {
        try {
            return this.getService().PedCalcEcc(n, byArray, posByteArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1;
        }
    }

    public String getTamperSensorPath(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        PosByteArray posByteArray = new PosByteArray();
        int n2 = this.SysSensorCheck(null, posByteArray);
        PosLog.e(TAG, "getTamperSensorPath ret = " + n2 + ", rspBuf.len = " + posByteArray.len);
        String string = PosUtils.bytesToHexString(posByteArray.buffer);
        PosLog.e(TAG, "getTamperSensorPath sensorValue = " + string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            int n3 = 0;
            int n4 = 0;
            n4 += (posByteArray.buffer[0] & 0xFF) << 24;
            n4 += (posByteArray.buffer[1] & 0xFF) << 16;
            n4 += (posByteArray.buffer[2] & 0xFF) << 8;
            n4 += posByteArray.buffer[3] & 0xFF;
            switch (n) {
                case 8: {
                    n3 = 8;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 8 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 8 ok\n");
                    }
                }
                case 7: {
                    n3 = 7;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 7 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 7 ok\n");
                    }
                }
                case 6: {
                    n3 = 6;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 6 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 6 ok\n");
                    }
                }
                case 5: {
                    n3 = 5;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 5 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 5 ok\n");
                    }
                }
                case 4: {
                    n3 = 4;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 4 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 4 ok\n");
                    }
                }
                case 3: {
                    n3 = 3;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 3 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 3 ok\n");
                    }
                }
                case 2: {
                    n3 = 2;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 2 error, please check!\n");
                    } else {
                        stringBuilder.append("Path 2 ok\n");
                    }
                }
                case 1: {
                    n3 = 1;
                    if ((n4 & 1 << n3) != 0) {
                        stringBuilder.append("Path 1 error, please check!\n");
                        break;
                    }
                    stringBuilder.append("Path 1 ok\n");
                    break;
                }
                default: {
                    PosLog.e(TAG, "getTamperSensorPath maxPath invalid, Please check!");
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(EventListener eventListener) {
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (DEBUG) {
                PosLog.d(TAG, "registerListener listener= " + eventListener);
            }
            if (eventListener != null && !this.mListeners.contains(eventListener)) {
                if (!POIServiceManager.getDefault().isSupportMultiUsersCallback()) {
                    this.mListeners.clear();
                }
                this.mListeners.add(eventListener);
                if (this.mListeners.size() == 1) {
                    try {
                        this.getService().registerListener(this.mSecurityListener);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(EventListener eventListener) {
        if (DEBUG) {
            PosLog.d(TAG, "unregisterListener listener= " + eventListener);
        }
        ArrayList<EventListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(eventListener);
        }
    }

    private class SecurityListener
    extends IPosSecurityListener.Stub {
        private SecurityListener() {
        }

        @Override
        public void onInfo(int n, int n2) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(1, n, n2));
            }
        }

        @Override
        public void onError(int n, int n2) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(2, n, n2));
            }
        }

        @Override
        public void onKeyboardShow(byte[] byArray, int n) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(3, n, 0, byArray));
            }
        }

        @Override
        public void onKeyboardInput(int n) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(4, n, 0));
            }
        }

        @Override
        public void onPedPinBlockRet(int n, byte[] byArray) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(5, n, 0, byArray));
            }
        }

        @Override
        public void onPedVerifyPin(int n, byte[] byArray) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(6, n, 0, byArray));
            }
        }

        @Override
        public void onHwSelfCheckRet(int n, int n2) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(7, n, n2));
            }
        }

        @Override
        public void onHwSensorTriggered(int n, byte[] byArray, byte[] byArray2) {
            if (POIHsmManage.this.mEventHandler != null) {
                Bundle bundle = new Bundle();
                bundle.putByteArray("sensorValue", byArray);
                bundle.putByteArray("triggerTime", byArray2);
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(8, n, 0, bundle));
            }
        }

        @Override
        public void onPedKeyManageRet(int n) {
            if (POIHsmManage.this.mEventHandler != null) {
                POIHsmManage.this.mEventHandler.sendMessage(POIHsmManage.this.mEventHandler.obtainMessage(9, n, 0));
            }
        }
    }

    private class EventHandler
    extends Handler {
        private POIHsmManage mSecurityManager;

        public EventHandler(POIHsmManage pOIHsmManage2, Looper looper) {
            super(looper);
            this.mSecurityManager = pOIHsmManage2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onInfo listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onInfo(this.mSecurityManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onInfo failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 2: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onError listener= " + eventListener + ", msg.arg1= " + message.arg1 + ", msg.arg2=" + message.arg2);
                                }
                                eventListener.onError(this.mSecurityManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onError failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 3: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onKeyboardShow listener= " + eventListener + ", msg.arg1= " + message.arg1);
                                }
                                eventListener.onKeyboardShow(this.mSecurityManager, (byte[])message.obj, message.arg1);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onKeyboardShow failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onKeyboardInput listener= " + eventListener + ", msg.arg1= " + message.arg1);
                                }
                                eventListener.onKeyboardInput(this.mSecurityManager, message.arg1);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onKeyboardInput failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 5: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onPedPinBlockRet listener= " + eventListener + ", msg.arg1= " + message.arg1);
                                }
                                eventListener.onPedPinBlockRet(this.mSecurityManager, message.arg1, (byte[])message.obj);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onPedPinBlockRet failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 6: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onPedVerifyPin listener= " + eventListener + ", msg.arg1= " + message.arg1);
                                }
                                eventListener.onPedVerifyPin(this.mSecurityManager, message.arg1, (byte[])message.obj);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onPedVerifyPin failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 7: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onHwSelfCheckRet listener= " + eventListener + ", msg.arg1= " + message.arg1);
                                }
                                eventListener.onHwSelfCheckRet(this.mSecurityManager, message.arg1, message.arg2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onHwSelfCheckRet failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 8: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onHwSensorTriggered listener= " + eventListener + ", triggered= " + message.arg1);
                                }
                                Bundle bundle = (Bundle)message.obj;
                                byte[] byArray = bundle.getByteArray("sensorValue");
                                byte[] byArray2 = bundle.getByteArray("triggerTime");
                                eventListener.onHwSensorTriggered(this.mSecurityManager, message.arg1, byArray, byArray2);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onHwSensorTriggered failed", exception);
                            }
                        }
                        break;
                    }
                }
                case 9: {
                    ArrayList arrayList = POIHsmManage.this.mListeners;
                    synchronized (arrayList) {
                        for (EventListener eventListener : POIHsmManage.this.mListeners) {
                            try {
                                if (DEBUG) {
                                    PosLog.d(POIHsmManage.TAG, "onPasswordManageRet listener= " + eventListener + ", triggered= " + message.arg1);
                                }
                                eventListener.onPedKeyManageRet(this.mSecurityManager, message.arg1);
                            }
                            catch (Exception exception) {
                                PosLog.e(POIHsmManage.TAG, "Listener for onPasswordManageRet failed", exception);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface EventListener {
        public void onInfo(POIHsmManage var1, int var2, int var3);

        public void onError(POIHsmManage var1, int var2, int var3);

        public void onKeyboardShow(POIHsmManage var1, byte[] var2, int var3);

        public void onKeyboardInput(POIHsmManage var1, int var2);

        public void onPedPinBlockRet(POIHsmManage var1, int var2, byte[] var3);

        public void onPedVerifyPin(POIHsmManage var1, int var2, byte[] var3);

        public void onHwSelfCheckRet(POIHsmManage var1, int var2, int var3);

        public void onHwSensorTriggered(POIHsmManage var1, int var2, byte[] var3, byte[] var4);

        public void onPedKeyManageRet(POIHsmManage var1, int var2);
    }
}

