/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.utils;

import android.text.TextUtils;
import com.pos.sdk.PosLog;
import java.util.LinkedHashMap;

public class PosParameters {
    private static final String TAG = "PosParameters";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected final LinkedHashMap<String, String> mMap = new LinkedHashMap(64);

    public void dump() {
        PosLog.e(TAG, "dump: size=" + this.mMap.size());
        for (String string : this.mMap.keySet()) {
            PosLog.e(TAG, "dump: " + string + "=" + this.mMap.get(string));
        }
    }

    public String flatten() {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (String string : this.mMap.keySet()) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(this.mMap.get(string));
            stringBuilder.append(";");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public void unflatten(String string) {
        this.mMap.clear();
        TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(';');
        simpleStringSplitter.setString(string);
        for (String string2 : simpleStringSplitter) {
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.mMap.put(string3, string4);
        }
    }

    public void remove(String string) {
        this.mMap.remove(string);
    }

    public void set(String string, String string2) {
        if (string.indexOf(61) != -1 || string.indexOf(59) != -1 || string.indexOf(0) != -1) {
            PosLog.e(TAG, "Key \"" + string + "\" contains invalid character (= or ; or \\0)");
            return;
        }
        if (string2.indexOf(61) != -1 || string2.indexOf(59) != -1 || string2.indexOf(0) != -1) {
            PosLog.e(TAG, "Value \"" + string2 + "\" contains invalid character (= or ; or \\0)");
            return;
        }
        this.put(string, string2);
    }

    public void set(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void set(String string, boolean bl) {
        this.put(string, Boolean.toString(bl));
    }

    public void set(String string, float f) {
        this.put(string, Float.toString(f));
    }

    private void put(String string, String string2) {
        this.mMap.remove(string);
        this.mMap.put(string, string2);
    }

    public String get(String string) {
        return this.mMap.get(string);
    }

    public int getInt(String string) {
        try {
            return Integer.parseInt(this.mMap.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean getBoolean(String string) {
        try {
            return Boolean.parseBoolean(this.mMap.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public float getFloat(String string) {
        try {
            return Float.parseFloat(this.mMap.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }
}

