/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.utils;

import com.pos.sdk.utils.PosUtils;

public class PosTlv {
    private static final String TAG = "PosTlv";
    private byte[] mRecord;
    private int mTlvOffset;
    private int mTlvLength;
    private int mCurOffset;
    private int mCurDataOffset;
    private int mCurDataLength;
    private boolean mHasValidTlvObject;

    public PosTlv(byte[] byArray) {
        this.mRecord = byArray;
        this.mTlvOffset = 0;
        this.mTlvLength = byArray.length;
        this.mCurOffset = 0;
        this.mHasValidTlvObject = this.parseCurrentTlvObject();
    }

    public PosTlv(byte[] byArray, int n, int n2) {
        this.mRecord = byArray;
        this.mTlvOffset = n;
        this.mTlvLength = n2;
        this.mCurOffset = n;
        this.mHasValidTlvObject = this.parseCurrentTlvObject();
    }

    public boolean nextObject() {
        if (!this.mHasValidTlvObject) {
            return false;
        }
        this.mCurOffset = this.mCurDataOffset + this.mCurDataLength;
        this.mHasValidTlvObject = this.parseCurrentTlvObject();
        return this.mHasValidTlvObject;
    }

    public boolean isValidObject() {
        return this.mHasValidTlvObject;
    }

    public int getTag() {
        if (!this.mHasValidTlvObject) {
            return 0;
        }
        return this.mRecord[this.mCurOffset] & 0xFF;
    }

    public byte[] getData() {
        if (!this.mHasValidTlvObject) {
            return null;
        }
        byte[] byArray = new byte[this.mCurDataLength];
        System.arraycopy(this.mRecord, this.mCurDataOffset, byArray, 0, this.mCurDataLength);
        return byArray;
    }

    private boolean parseCurrentTlvObject() {
        block6: {
            try {
                if (this.mRecord[this.mCurOffset] == 0 || (this.mRecord[this.mCurOffset] & 0xFF) == 255) {
                    return false;
                }
                if ((this.mRecord[this.mCurOffset + 1] & 0xFF) < 128) {
                    this.mCurDataLength = this.mRecord[this.mCurOffset + 1] & 0xFF;
                    this.mCurDataOffset = this.mCurOffset + 2;
                    break block6;
                }
                if ((this.mRecord[this.mCurOffset + 1] & 0xFF) == 129) {
                    this.mCurDataLength = this.mRecord[this.mCurOffset + 2] & 0xFF;
                    this.mCurDataOffset = this.mCurOffset + 3;
                    break block6;
                }
                if ((this.mRecord[this.mCurOffset + 1] & 0xFF) == 130) {
                    this.mCurDataLength = (this.mRecord[this.mCurOffset + 2] & 0xFF) << 8 | this.mRecord[this.mCurOffset + 3] & 0xFF;
                    this.mCurDataOffset = this.mCurOffset + 4;
                    break block6;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        return this.mCurDataLength + this.mCurDataOffset <= this.mTlvOffset + this.mTlvLength;
    }

    public static byte[] constructTlvObject(int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (byArray == null || n3 < 0 || n3 > byArray.length || n2 > byArray.length) {
            return null;
        }
        byArray2 = new byte[3];
        if (byArray2 != null) {
            if (n3 < 128) {
                n4 = 1;
                byArray2[0] = (byte)(n3 & 0xFF);
            } else if (n3 >= 128 && n3 <= 255) {
                n4 = 2;
                byArray2[0] = -127;
                byArray2[1] = (byte)(n3 & 0xFF);
            } else if (n3 > 255 && n3 <= 65535) {
                n4 = 3;
                byArray2[0] = -126;
                byArray2[1] = (byte)(n3 >> 8 & 0xFF);
                byArray2[2] = (byte)(n3 & 0xFF);
            } else {
                return null;
            }
            byArray3 = new byte[1 + n4 + n3];
            if (byArray3 != null) {
                byArray3[n5++] = (byte)(n & 0xFF);
                System.arraycopy(byArray2, 0, byArray3, n5, n4);
                System.arraycopy(byArray, n2, byArray3, n5 += n4, n3);
            }
        }
        return byArray3;
    }

    public static byte[] constructTlvObject(int n, byte[] byArray) {
        return PosTlv.constructTlvObject(n, byArray, 0, byArray.length);
    }

    public static byte[] constructTlvObject(int n, byte by) {
        return PosTlv.constructTlvObject(n, new byte[]{by}, 0, 1);
    }

    public static byte[] constructTlvObject(int n, short s) {
        return PosTlv.constructTlvObject(n, PosUtils.shortToBytesBe(s));
    }

    public static byte[] constructTlvObject(int n, int n2) {
        return PosTlv.constructTlvObject(n, PosUtils.intToBytesBe(n2));
    }
}

