/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.utils;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.SystemProperties;
import android.text.TextUtils;
import com.pos.sdk.PosLog;
import com.pos.sdk.accessory.POIGeneralAPI;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class PosUtils {
    private static final String TAG = "PosUtils";

    public static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("invalid hex char '" + c + "'");
    }

    public static String bytesToAscii(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0 || n < 0 || n2 <= 0) {
            return null;
        }
        if (n >= byArray.length || byArray.length - n < n2) {
            return null;
        }
        String string = null;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        try {
            string = new String(byArray2, "ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static String bytesToAscii(byte[] byArray, int n) {
        return PosUtils.bytesToAscii(byArray, 0, n);
    }

    public static String bytesToAscii(byte[] byArray) {
        return PosUtils.bytesToAscii(byArray, 0, byArray.length);
    }

    public static String bytesToHexString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "null!";
        }
        StringBuilder stringBuilder = new StringBuilder(2 * n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = 0xF & byArray[n + i] >> 4;
            stringBuilder.append("0123456789abcdef".charAt(n3));
            n3 = 0xF & byArray[n + i];
            stringBuilder.append("0123456789abcdef".charAt(n3));
        }
        return stringBuilder.toString();
    }

    public static String bytesToHexString(byte[] byArray, int n) {
        return byArray == null ? "null!" : PosUtils.bytesToHexString(byArray, 0, n);
    }

    public static String bytesToHexString(byte[] byArray) {
        return byArray == null ? "null!" : PosUtils.bytesToHexString(byArray, byArray.length);
    }

    public static byte[] hexStringToBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        try {
            byte[] byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byArray[i / 2] = (byte)(PosUtils.hexCharToInt(string.charAt(i)) << 4 | PosUtils.hexCharToInt(string.charAt(i + 1)));
            }
            return byArray;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static byte[] shortToBytesLe(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(s >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public static byte[] shortToBytesBe(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[byArray.length - i - 1] = (byte)(s >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public static byte[] intToBytesLe(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public static byte[] intToBytesBe(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[byArray.length - i - 1] = (byte)(n >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public static int bytesToIntLe(byte[] byArray) {
        if (byArray == null || byArray.length > 4) {
            throw new RuntimeException("invalid arg");
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public static int bytesToIntLe(byte[] byArray, int n, int n2) {
        return PosUtils.bytesToIntLe(Arrays.copyOfRange(byArray, n, n2));
    }

    public static int bytesToIntBe(byte[] byArray) {
        if (byArray == null || byArray.length > 4) {
            throw new RuntimeException("invalid arg");
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (byArray[i] & 0xFF) << (byArray.length - i - 1) * 8;
        }
        return n;
    }

    public static int bytesToIntBe(byte[] byArray, int n, int n2) {
        return PosUtils.bytesToIntBe(Arrays.copyOfRange(byArray, n, n2));
    }

    public static int bytesToIntLe(byte by, byte by2, byte by3, byte by4) {
        int n = 0;
        n = by & 0xFF;
        n += (by2 & 0xFF) << 8;
        n += (by3 & 0xFF) << 16;
        return n += (by4 & 0xFF) << 24;
    }

    public static int bytesToIntBe(byte by, byte by2, byte by3, byte by4) {
        int n = 0;
        n = (by & 0xFF) << 24;
        n += (by2 & 0xFF) << 16;
        n += (by3 & 0xFF) << 8;
        return n += by4 & 0xFF;
    }

    public static short bytesToShortLe(byte[] byArray) {
        if (byArray == null || byArray.length > 2) {
            throw new RuntimeException("invalid arg");
        }
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            s = (short)(s + ((byArray[i] & 0xFF) << i * 8));
        }
        return s;
    }

    public static short bytesToShortLe(byte[] byArray, int n, int n2) {
        return PosUtils.bytesToShortLe(Arrays.copyOfRange(byArray, n, n2));
    }

    public static short bytesToShortBe(byte[] byArray) {
        if (byArray == null || byArray.length > 2) {
            throw new RuntimeException("invalid arg");
        }
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            s = (short)(s + ((byArray[i] & 0xFF) << (byArray.length - i - 1) * 8));
        }
        return s;
    }

    public static short bytesToShortBe(byte[] byArray, int n, int n2) {
        return PosUtils.bytesToShortBe(Arrays.copyOfRange(byArray, n, n2));
    }

    public static short bytesToShortLe(byte by, byte by2) {
        short s = 0;
        s = (short)(by & 0xFF);
        s = (short)(s + (short)((by2 & 0xFF) << 8));
        return s;
    }

    public static short bytesToShortBe(byte by, byte by2) {
        short s = 0;
        s = (short)((by & 0xFF) << 8);
        s = (short)(s + (short)(by2 & 0xFF));
        return s;
    }

    public static void byteArraySetByte(byte[] byArray, byte by, int n) {
        byArray[n] = by;
    }

    public static void byteArraySetByte(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
    }

    public static void byteArraySetBytes(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void byteArraySetWord(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
    }

    public static void byteArraySetWordBe(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n & 0xFF);
    }

    public static void byteArraySetInt(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    public static void byteArraySetIntBe(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static void delayms(int n) {
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean isAscii(char c) {
        return c <= '\u007f';
    }

    public static boolean isAscii(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (PosUtils.isAscii(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAsciiChar(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!PosUtils.isAscii(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigitOrEnCharacter(byte by) {
        return by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122;
    }

    public static String bcdToDecString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((byte)((byArray[i] & 0xF0) >>> 4));
            stringBuffer.append((byte)(byArray[i] & 0xF));
        }
        return stringBuffer.toString().substring(0, 1).equalsIgnoreCase("0") ? stringBuffer.toString().substring(1) : stringBuffer.toString();
    }

    public static byte[] decStringToBcd(String string) {
        int n = string.length();
        int n2 = n % 2;
        if (n2 != 0) {
            string = "0" + string;
            n = string.length();
        }
        byte[] byArray = new byte[n];
        if (n >= 2) {
            n /= 2;
        }
        byte[] byArray2 = new byte[n];
        byArray = string.getBytes();
        for (int i = 0; i < string.length() / 2; ++i) {
            byte by;
            int n3 = byArray[2 * i] >= 48 && byArray[2 * i] <= 57 ? byArray[2 * i] - 48 : (byArray[2 * i] >= 97 && byArray[2 * i] <= 122 ? byArray[2 * i] - 97 + 10 : byArray[2 * i] - 65 + 10);
            int n4 = byArray[2 * i + 1] >= 48 && byArray[2 * i + 1] <= 57 ? byArray[2 * i + 1] - 48 : (byArray[2 * i + 1] >= 97 && byArray[2 * i + 1] <= 122 ? byArray[2 * i + 1] - 97 + 10 : byArray[2 * i + 1] - 65 + 10);
            int n5 = (n3 << 4) + n4;
            byArray2[i] = by = (byte)n5;
        }
        return byArray2;
    }

    public static byte[] stringToBcd(String string) {
        return PosUtils.stringToBcd(string, string != null ? string.length() : 0);
    }

    public static byte[] stringToBcd(String string, int n) {
        if (n % 2 != 0) {
            ++n;
        }
        while (string.length() < n) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < cArray.length; n2 += 2) {
            int n4 = 0;
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                n4 = cArray[n2] - 48 << 4;
            } else {
                if (cArray[n2] >= 'a' && cArray[n2] <= 'f') {
                    int n5 = n2;
                    cArray[n5] = (char)(cArray[n5] - 32);
                }
                n4 = cArray[n2] - 48 - 7 << 4;
            }
            if (cArray[n2 + 1] >= '0' && cArray[n2 + 1] <= '9') {
                n4 += cArray[n2 + 1] - 48;
            } else {
                if (cArray[n2 + 1] >= 'a' && cArray[n2 + 1] <= 'f') {
                    int n6 = n2 + 1;
                    cArray[n6] = (char)(cArray[n6] - 32);
                }
                n4 += cArray[n2 + 1] - 48 - 7;
            }
            byArray[n3] = (byte)n4;
            ++n3;
        }
        return byArray;
    }

    public static String bcdToString(byte[] byArray) {
        return PosUtils.bcdToString(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public static String bcdToString(byte[] byArray, int n, int n2) {
        if (n2 <= 0 || n < 0 || byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(Integer.toHexString((byArray[i + n] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[i + n] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static void validatePermission(Context context, String string) {
        if (SystemProperties.get((String)"ro.pos.system.permission", (String)"0").equals("1") && Binder.getCallingUid() != 1000) {
            throw new SecurityException(String.format("Permission denied, requires android.uid.system.", new Object[0]));
        }
    }

    public static void checkVersion(String string) {
        String string2 = "2.2.54.20240617";
        String string3 = SystemProperties.get((String)"sys.pos.sub_service_version");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            POIGeneralAPI.getDefault().setProperty("sys.pos.sub_sdk_version", string2);
        }
        if (!TextUtils.equals((CharSequence)string2, (CharSequence)string3)) {
            PosLog.w(string, "SDK_VERSION=(" + string2 + ") is not equals with SERVICE_VERSION=(" + string3 + "), may cause compatibility issue!");
        }
    }

    public static Bundle jsonString2Bundle(String string) {
        Bundle bundle = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject = new JSONObject(string);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2;
                    Object object;
                    if (bundle == null) {
                        bundle = new Bundle();
                    }
                    if ((object = jSONObject.get(string2 = (String)iterator.next())) instanceof Integer) {
                        bundle.putInt(string2, ((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        bundle.putLong(string2, ((Long)object).longValue());
                        continue;
                    }
                    if (object instanceof Float) {
                        bundle.putFloat(string2, ((Float)object).floatValue());
                        continue;
                    }
                    if (object instanceof Double) {
                        bundle.putDouble(string2, ((Double)object).doubleValue());
                        continue;
                    }
                    if (object instanceof String) {
                        bundle.putString(string2, (String)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                        continue;
                    }
                    PosLog.e(TAG, "jsonString2Bundle:: not support object type key= " + string2 + ", value= " + object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bundle;
    }

    public static String getProcessNameByPid(int n) {
        try {
            List list = ActivityManagerNative.getDefault().getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.processName;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String getProperty(String string, String string2) {
        return SystemProperties.get((String)string, (String)string2);
    }
}

