/*
 * Decompiled with CFR 0.152.
 */
package com.pos.sdk.utils.attack;

import com.pos.sdk.utils.attack.AttackType;
import java.util.ArrayList;
import java.util.List;

public enum AttackValue {
    SENSOR_PATH_1(1, "Tamper Sensor Path 1"),
    SENSOR_PATH_2(2, "Tamper Sensor Path 2"),
    SENSOR_PATH_3(3, "Tamper Sensor Path 3"),
    SENSOR_PATH_4(4, "Tamper Sensor Path 4"),
    SENSOR_PATH_5(5, "Tamper Sensor Path 5"),
    SENSOR_PATH_6(6, "Tamper Sensor Path 6"),
    SENSOR_PATH_7(7, "Tamper Sensor Path 7"),
    SENSOR_PATH_8(8, "Tamper Sensor Path 8"),
    CLOCK_SENSOR(16, "Clock Sensor"),
    VOLTAGE_HIGH(17, "Voltage High"),
    VOLTAGE_LOW(18, "Voltage Low"),
    TEMPERATURE_HIGH(19, "Temperature High"),
    TEMPERATURE_LOW(20, "Temperature Low"),
    CPU_SENSOR(21, "CPU Sensor"),
    SOFT_SENSOR(22, "Soft Sensor"),
    GLITCH_SENSOR(23, "Glitch Sensor"),
    PED_FORMAT(0, "PED Format"),
    PED_UNLOCK(1, "PED Unlock"),
    PED_ERROR(2, "PED Error"),
    SEK_INVALID(3, "SEK Invalid"),
    SEK_CRC_ERROR(4, "SEK CRC Error"),
    SEK_ZERO(5, "SEK Zero"),
    FILE_NOT_EXIST(6, "File Not Exist"),
    MKSK_INVALID(7, "MKSK Invalid"),
    MKSK_ATTR_ERROR(8, "MKSK ATTR Error"),
    MKSK_CRC_ERROR(9, "MKSK CRC Error");

    public final int type;
    public final String name;

    private AttackValue(int n2, String string2) {
        this.type = n2;
        this.name = string2;
    }

    public static List<AttackValue> parser(AttackType attackType, byte[] byArray) {
        ArrayList<AttackValue> arrayList = new ArrayList<AttackValue>();
        int n = 0;
        n += (byArray[0] & 0xFF) << 24;
        n += (byArray[1] & 0xFF) << 16;
        n += (byArray[2] & 0xFF) << 8;
        n += byArray[3] & 0xFF;
        if (attackType == AttackType.SENSOR) {
            int n2 = AttackValue.SENSOR_PATH_1.type;
            if ((n & 1 << n2) != 0) {
                arrayList.add(SENSOR_PATH_1);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_2.type)) != 0) {
                arrayList.add(SENSOR_PATH_2);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_3.type)) != 0) {
                arrayList.add(SENSOR_PATH_3);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_4.type)) != 0) {
                arrayList.add(SENSOR_PATH_4);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_5.type)) != 0) {
                arrayList.add(SENSOR_PATH_5);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_6.type)) != 0) {
                arrayList.add(SENSOR_PATH_6);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_7.type)) != 0) {
                arrayList.add(SENSOR_PATH_7);
            }
            if ((n & 1 << (n2 = AttackValue.SENSOR_PATH_8.type)) != 0) {
                arrayList.add(SENSOR_PATH_8);
            }
            if ((n & 1 << (n2 = AttackValue.CLOCK_SENSOR.type)) != 0) {
                arrayList.add(CLOCK_SENSOR);
            }
            if ((n & 1 << (n2 = AttackValue.VOLTAGE_HIGH.type)) != 0) {
                arrayList.add(VOLTAGE_HIGH);
            }
            if ((n & 1 << (n2 = AttackValue.VOLTAGE_LOW.type)) != 0) {
                arrayList.add(VOLTAGE_LOW);
            }
            if ((n & 1 << (n2 = AttackValue.TEMPERATURE_HIGH.type)) != 0) {
                arrayList.add(TEMPERATURE_HIGH);
            }
            if ((n & 1 << (n2 = AttackValue.TEMPERATURE_LOW.type)) != 0) {
                arrayList.add(TEMPERATURE_LOW);
            }
            if ((n & 1 << (n2 = AttackValue.CPU_SENSOR.type)) != 0) {
                arrayList.add(CPU_SENSOR);
            }
            if ((n & 1 << (n2 = AttackValue.SOFT_SENSOR.type)) != 0) {
                arrayList.add(SOFT_SENSOR);
            }
            if ((n & 1 << (n2 = AttackValue.GLITCH_SENSOR.type)) != 0) {
                arrayList.add(GLITCH_SENSOR);
            }
        } else {
            switch (n) {
                case 0: {
                    arrayList.add(PED_FORMAT);
                    break;
                }
                case 1: {
                    arrayList.add(PED_UNLOCK);
                    break;
                }
                case 2: {
                    arrayList.add(PED_ERROR);
                    break;
                }
                case 3: {
                    arrayList.add(SEK_INVALID);
                    break;
                }
                case 4: {
                    arrayList.add(SEK_CRC_ERROR);
                    break;
                }
                case 5: {
                    arrayList.add(SEK_ZERO);
                    break;
                }
                case 6: {
                    arrayList.add(FILE_NOT_EXIST);
                    break;
                }
                case 7: {
                    arrayList.add(MKSK_INVALID);
                    break;
                }
                case 8: {
                    arrayList.add(MKSK_ATTR_ERROR);
                    break;
                }
                default: {
                    arrayList.add(MKSK_CRC_ERROR);
                }
            }
        }
        return arrayList;
    }
}

