package com.xc.apex.nre.nrep8posdemo

import android.app.Application
import android.content.Context
import android.os.Handler
import android.util.Log
import com.xc.apex.nre.lib_payment.PaymentManager
import com.xc.apex.nre.lib_payment.PaymentManager.InitPaymentCallbackListener
//import com.xctech.collaboration.sdk.CollaborationSDK as NewCollaborationSDK
import com.xctech.collaboration.core.SdkInitResult
import com.xctech.collaboration.core.SdkLogger
import com.xctech.collaboration.sdk.CollaborationSDK

class BaseApplicationV2 : Application() {

    override fun onCreate() {
        super.onCreate()
        context = getApplicationContext()
        INSTANCE = this

        initNewCollaborationSDK()
        // 初始化金融SDK
        PaymentManager.getInstance(getContext())
            .initPaymentSdk(object : InitPaymentCallbackListener {
                override fun onInitResult(isSuccess: Boolean, e: Exception?) {
                    Log.e(
                        TAG,
                        "Payment SDK init " + (if (isSuccess) "Success." else "Failed:: " + e?.message)
                    )
                }
            })


    }


    /**
     * 初始化新的 CollaborationSDK (用于触发 Michael Agent 模块)
     */
    private fun initNewCollaborationSDK() {
        SdkLogger.enabled = true
        SdkLogger.logLevel = SdkLogger.Level.DEBUG
        val result = CollaborationSDK.init(
            context = this,
            name = "MyApp",      // 你的 APP 名称
            version = "1.0.0"    // 你的 APP 版本
        )

        when (result) {
            is SdkInitResult.Success -> {
                collaborationSDK = result.sdk
                Log.i(TAG, "New CollaborationSDK 初始化成功")
            }
            is SdkInitResult.Failure -> {
                Log.e(TAG, "New CollaborationSDK 初始化失败: ${result.error.message}")
            }
        }
    }

    companion object {
        private const val TAG = "NRE_P8_Application"
        private var context: Context? = null

        lateinit var INSTANCE: BaseApplicationV2

        // 新的 SDK 实例（用于触发 Michael Agent 模块）
        private var collaborationSDK: CollaborationSDK? = null
            private set

        //定义minchale 服务和 开始结束命令
        val SERVICE_ID_MINCHALE = "michael-service"
        val COMMAND_START_MINCHALE = "startAsr"
        val COMMAND_STOP_MINCHALE = "stopAsr"

        fun getContext(): Context {

            return context!!
        }

        @JvmStatic
        fun getCollaborationSDK(): CollaborationSDK? {
            return collaborationSDK
        }
    }

}