package com.xc.apex.nre.nrep8posdemo.edgeos

import android.content.Context
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.BaseMethod
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment

/**
 * EdgeOS 辅助类，用于存储 Context、SalesFragment 和方法实例映射
 */
object EdgeOSHelper {
    @Volatile
    @JvmField
    var context: Context? = null

    @Volatile
    @JvmField
    var salesFragment: SalesFragment? = null

    // 存储所有方法实例
    private val methods = mutableMapOf<String, BaseMethod<*>>()

    /**
     * 注册方法实例
     */
    @JvmStatic
    fun registerMethod(method: BaseMethod<*>) {
        methods[method.getId()] = method
    }

    /**
     * 获取方法实例
     */
    @JvmStatic
    fun getMethod(id: String): BaseMethod<*>? {
        return methods[id]
    }
}

