package com.xc.apex.nre.nrep8posdemo.edgeos;

import android.content.Context;
import android.util.Log;

import com.xc.apex.nre.nrep8posdemo.edgeos.methods.AddGoodsMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.BatchAddGoodsMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.ClearGoodsMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.GetGoodsListMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.GetSelectedGoods;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.GoHomeMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.RemoveGoodsMethod;
import com.xc.apex.nre.nrep8posdemo.edgeos.methods.SubmitOrderMethod;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

/**
 * 接入EdgeOS协同服务
 * 新版 SDK 使用注解方式注册，此类仅用于初始化方法实例到 EdgeOSHelper
 */
public class EdgeOSService {

    /**
     * 初始化
     * @param context Context
     * @param fragment SalesFragment
     */
    public static void init(Context context, SalesFragment fragment) {
        // 设置辅助类引用
        EdgeOSHelper.context = context;
        EdgeOSHelper.salesFragment = fragment;

        // 创建方法实例并注册到 Helper
        EdgeOSHelper.registerMethod(new AddGoodsMethod(context, fragment));
        EdgeOSHelper.registerMethod(new ClearGoodsMethod(context, fragment));
        EdgeOSHelper.registerMethod(new SubmitOrderMethod(context, fragment));
        EdgeOSHelper.registerMethod(new GoHomeMethod(context, fragment));
        EdgeOSHelper.registerMethod(new RemoveGoodsMethod(context, fragment));
        EdgeOSHelper.registerMethod(new GetGoodsListMethod(context, fragment));
        EdgeOSHelper.registerMethod(new BatchAddGoodsMethod(context, fragment));
        EdgeOSHelper.registerMethod(new GetSelectedGoods(context, fragment));

        Log.d("EdgeOS", "注册方法到 EdgeOSHelper 完成，共 " + 8 + " 个方法");
    }
}
