package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;
import android.util.Log;

import com.xc.apex.nre.nrep8posdemo.model.GoodsBean;
import com.xc.apex.nre.nrep8posdemo.utils.GoodsDataUtil;
import com.xc.apex.nre.nrep8posdemo.utils.Quantity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AddGoodsMethod extends BaseMethod<JSONObject> {
    public AddGoodsMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "addGoods";
    }

    @Override
    public String getName() {
        return "添加商品到购物车 / Add product to shopping cart.";
    }

    @Override
    public String getDescription() {
        return "添加商品到购物车 / Add product to shopping cart.";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {

        Log.d("AddGoodsMethod", "params: " + params);
        // id 和 name 二选一
        if (!params.containsKey("id") && !params.containsKey("name")) {
            return returnData(false, "id和name不能同时为空");
        }
        // 取出所有商品列表
        List<GoodsBean> goodsList = GoodsDataUtil.getInstance(getContext()).getGoodsListData();

        GoodsBean goods = null;
        // 优先按id匹配
        if (params.containsKey("id")) {
            try {
                Object quantityObj = params.get("id");
                Quantity quantity = new Quantity(quantityObj);

                Log.d("AddGoodsMethod", "quantity: " + quantity);
                int data = quantity.toInt();
                Log.d("AddGoodsMethod", "quantity Int data: " + data);
                for (int i = 0; i < goodsList.size(); i++) {
                    if ( data == goodsList.get(i).getId()) {
                        goods = goodsList.get(i);
                        break;
                    }
                }
            } catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }

        // 其次使用name匹配
        // id 和 name共存时，若id找不到商品也会进入这里
        if (params.containsKey("name") && goods == null) {
            // name 是模糊匹配，这里按匹配度取最大的商品
            // name 匹配会忽略大小写，也会忽略空格
            // 匹配度 = name长度 / 商品名长度
            double match = 0;
            String name = filterName(((String) Objects.requireNonNull(params.get("name"))));
            String goodsName;
            for (int i = 0; i < goodsList.size(); i++) {
                goodsName = filterName(goodsList.get(i).getName());
                if (goodsName.contains(name)) {
                    if ((double) name.length() / goodsName.length() > match) {
                        match = (double) name.length() / goodsName.length();
                        goods = goodsList.get(i);
                    }
                }
            }
        }

        if (goods == null) {
            return returnData(false, "找不到商品");
        }

        Object quantityObj = params.get("quantity");
        Quantity quantity = new Quantity(quantityObj);

        int quantityV2 = quantity.toInt();

        for (int i = 0; i < quantityV2; i++) {
            getFragment().addOrderItem(goods);
        }

        String name = goods.getName();
        return returnData(true, "新增"+name+quantityV2+"份成功");
    }

    private String filterName(String name) {
        name = name.toLowerCase();
        name = name.replace(" ", "");
        return name;
    }
}
