package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import androidx.appcompat.app.AppCompatActivity;

import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * 需要暴露的方法
 * @param <T> 方法返回值
 */
abstract public class BaseMethod<T> {
    private final Context context;
    private final SalesFragment fragment;

    public BaseMethod(Context context, SalesFragment fragment) {

        this.context = context;
        this.fragment = fragment;
    }

    public Context getContext() {
        return context;
    }

    public SalesFragment getFragment() {
        return fragment;
    }

    /**
     * 方法id
     */
    abstract public String getId();

    /**
     * 方法名称，用于Michael展示
     */
    abstract public String getName();

    /**
     * 方法描述，AI会解析该字段以决定如何使用方法
     */
    abstract public String getDescription();

    /**
     * 方法版本，语义化版本，比如 1.0.0
     */
    abstract public String getVersion();

    /**
     * 返回值类型
     */
    abstract public String getReturnType();

    /**
     * 方法执行具体实现
     * @param params Map<String, ?> 方法参数
     */
    abstract public T execute(Map<String, ?> params);

    /**
     * 预计的执行耗时，毫秒
     */
    public Long getEstimatedExecutionTime() {
        return 100L;
    }

    /**
     * 获取返回数据
     */
    protected JSONObject returnData(Boolean success, String message) {
        try {
            return new JSONObject().put("success", success).put("message", message);
        } catch (JSONException e) {
            return new JSONObject();
        }
    }
}
