package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;
import android.util.Log;

import com.xc.apex.nre.nrep8posdemo.model.GoodsBean;
import com.xc.apex.nre.nrep8posdemo.utils.GoodsDataUtil;
import com.xc.apex.nre.nrep8posdemo.utils.Quantity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatchAddGoodsMethod extends BaseMethod<JSONObject> {
    private static final String TAG = "BatchAddGoodsMethod";

    public BatchAddGoodsMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "batchAddGoods";
    }

    @Override
    public String getName() {
        return "批量添加商品";
    }

    @Override
    public String getDescription() {
        return "批量添加商品";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {
        try {
            Log.d(TAG, "BatchAddGoodsMethod params: " + params);
            JSONArray items = new JSONArray(Objects.requireNonNull(params.get("list")).toString());
            List<GoodsBean> goodsList = GoodsDataUtil.getInstance(getContext()).getGoodsListData();

            JSONObject item;
            int quantity;
            int id;
            boolean added;
            for(int i = 0; i < items.length(); i++) {
                try {
                    item = items.getJSONObject(i);
                    Quantity quantityOb = new Quantity(item.get("id"));

//                    id = item.getInt("id");
                    id = quantityOb.toInt();

                    Quantity quantityObV2 = new Quantity(item.has("quantity") ? item.get("quantity") : 1);

                    quantity = quantityObV2.toInt();

                } catch (Exception e) {
                    Log.e(TAG, "获取要添加的商品出错，这可能是入参的格式不符合规范: index=" + i);
                    Log.d(TAG, items.toString());
                    continue;
                }
                added = false;
                for(GoodsBean goods : goodsList) {
                    if (goods.getId() == id) {
                        for(int n = 0; n < quantity; n++) {
                            getFragment().addOrderItem(goods);
                        }
                        added = true;
                        break;
                    }
                }
                if (!added) {
                    Log.e(TAG, "添加购物车时找不到商品: index=" + i);
                }
            }

            return returnData(true, "操作成功");
        }
        catch (JSONException|NullPointerException e) {
            return returnData(false, e.getMessage());
        }
    }
}
