package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;
import android.util.Log;

import com.xc.apex.nre.nrep8posdemo.model.GoodsBean;
import com.xc.apex.nre.nrep8posdemo.model.OrderItemBean;
import com.xc.apex.nre.nrep8posdemo.utils.GoodsDataUtil;
import com.xc.apex.nre.nrep8posdemo.utils.Quantity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatchRemoveGoodsMethod extends BaseMethod<JSONObject> {
    private static final String TAG = "BatchRemoveGoodsMethod";

    public BatchRemoveGoodsMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "batchRemoveGoods";
    }

    @Override
    public String getName() {
        return "批量移除商品";
    }

    @Override
    public String getDescription() {
        return "批量移除商品";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {
        try {
            Log.d(TAG, "BatchRemoveGoodsMethod params: " + params);
            JSONArray items = new JSONArray(Objects.requireNonNull(params.get("list")).toString());
            List<GoodsBean> goodsList = GoodsDataUtil.getInstance(getContext()).getGoodsListData();
            List<OrderItemBean> orderItemList = getFragment().getOrderItemList();

            JSONObject item;
            int quantity;
            int id;
            boolean removed;

            for(int i = 0; i < items.length(); i++) {
                try {
                    item = items.getJSONObject(i);
                    Quantity quantityOb = new Quantity(item.get("id"));
                    id = quantityOb.toInt();

                    Quantity quantityObV2 = new Quantity(item.has("quantity") ? item.get("quantity") : 1);
                    quantity = quantityObV2.toInt();

                } catch (Exception e) {
                    Log.e(TAG, "获取要移除的商品出错，这可能是入参的格式不符合规范: index=" + i);
                    Log.d(TAG, items.toString());
                    continue;
                }

                removed = false;

                // 查找购物车中该商品的数量
                int currentQuantityInCart = 0;
                for(OrderItemBean orderItem : orderItemList) {
                    if (orderItem.getId() == id) {
                        currentQuantityInCart = orderItem.getNum();
                        break;
                    }
                }

                // 检查移除数量是否超过购物车中的数量
                if (currentQuantityInCart == 0) {
                    Log.e(TAG, "移除购物车时找不到商品: id=" + id);
                    continue;
                }

                if (quantity > currentQuantityInCart) {
                    Log.w(TAG, "移除数量(" + quantity + ")超过购物车中的商品总量(" + currentQuantityInCart + ")，将只移除购物车中的全部: id=" + id);
                    quantity = currentQuantityInCart;
                }

                // 从商品列表中找到对应的商品
                for(GoodsBean goods : goodsList) {
                    if (goods.getId() == id) {
                        // 移除指定数量的商品
                        for(int n = 0; n < quantity; n++) {
                            getFragment().subtractOrderItemSize(goods);
                        }
                        removed = true;
                        Log.d(TAG, "成功移除商品: id=" + id + ", 移除数量=" + quantity);
                        break;
                    }
                }

                if (!removed) {
                    Log.e(TAG, "移除购物车时在商品列表中找不到商品: id=" + id);
                }
            }

            return returnData(true, "操作成功");
        }
        catch (JSONException|NullPointerException e) {
            Log.e(TAG, "批量移除商品失败: " + e.getMessage(), e);
            return returnData(false, e.getMessage());
        }
    }
}