package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import com.xc.apex.nre.nrep8posdemo.view.MainTabActivity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONObject;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ClearGoodsMethod extends BaseMethod<JSONObject> {
    public ClearGoodsMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "clearGoods";
    }

    @Override
    public String getName() {
        return "清空购物车 / Clear shopping cart";
    }

    @Override
    public String getDescription() {
        return "调用该方法清空购物车内所有商品 / Call this method to clear all items in the shopping cart";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {
        ((MainTabActivity) getContext()).runOnUiThread(() -> {
            getFragment().clearAllOrder(false);
        });
        return returnData(true, "操作成功");
    }
}
