package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import com.google.gson.Gson;
import com.xc.apex.nre.nrep8posdemo.model.GoodsBean;
import com.xc.apex.nre.nrep8posdemo.utils.GoodsDataUtil;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GetGoodsListMethod extends BaseMethod<String> {
    public GetGoodsListMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "getGoods";
    }

    @Override
    public String getName() {
        return "获取商品列表，返回 markdown 表格";
    }

    @Override
    public String getDescription() {
        return "获取商品列表";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "string";
    }

    @Override
    public String execute(Map<String, ?> params) {
        // 把商品列表按markdown格式返回，方便AI理解
        List<GoodsBean> items = GoodsDataUtil.getInstance(getContext()).getGoodsListData();

        Gson gson = new Gson();
        return gson.toJson(items);
//        return result.toString();
    }
}
