package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import com.google.gson.Gson;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GetSelectedGoods extends BaseMethod<String>{
    public GetSelectedGoods(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String execute(Map<String, ?> params) {
        List<SimplifyGoodsBean> items = getFragment().getOrderItemList().stream().map(item -> new SimplifyGoodsBean(item.getName(), item.getNum())).collect(Collectors.toList());
        Gson gson = new Gson();
        return gson.toJson(items);
    }

    @Override
    public String getId() {
        return "getSelectedGoods";
    }

    @Override
    public String getName() {
        return "获取已选择菜品列表";
    }

    @Override
    public String getDescription() {
        return "获取当前已点选的菜品列表";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "string";
    }

    static class SimplifyGoodsBean {
        public String name;
        public int count;

        public SimplifyGoodsBean(String name, int count) {
            this.name = name;
            this.count = count;
        }

    }
}
