package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import com.xc.apex.nre.nrep8posdemo.view.MainTabActivity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScrollListMethod extends BaseMethod<JSONObject> {
    public ScrollListMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "scrollList";
    }

    @Override
    public String getName() {
        return "滑动商品列表 / Swipe the goods list";
    }

    @Override
    public String getDescription() {
        return "向上或向下滑动商品列表 / Swipe the goods list upward or downward.";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {
        boolean down = true;
        try {
            if (params != null && params.containsKey("down")) {
                down = (Boolean) params.get("down");
            }
        } catch (Exception ignore) {

        }
        boolean finalDown = down;
        ((MainTabActivity) getContext()).runOnUiThread(() -> {
            getFragment().getSalesBinding().rvGoods.smoothScrollToPosition(finalDown ? 100 : -100);
        });
        return returnData(true, "操作成功");
    }
}
