package com.xc.apex.nre.nrep8posdemo.edgeos.methods;

import android.content.Context;

import com.xc.apex.nre.nrep8posdemo.view.MainTabActivity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;

import org.json.JSONObject;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SubmitOrderMethod extends BaseMethod<JSONObject> {
    public SubmitOrderMethod(Context context, SalesFragment fragment) {
        super(context, fragment);
    }

    @Override
    public String getId() {
        return "submitOrder";
    }

    @Override
    public String getName() {
        return "提交订单 / Submit order";
    }

    @Override
    public String getDescription() {
        return "提交当前购物车内的商品并生成订单 / Submit the goods in the current shopping cart and generate an order";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getReturnType() {
        return "object";
    }

    @Override
    public JSONObject execute(Map<String, ?> params) {
        if (getFragment().getOrderItemCount() <= 0) {
            return returnData(false, "购物车内没有商品");
        }
        ((MainTabActivity) getContext()).runOnUiThread(() -> {
            getFragment().onOrderCreate();
        });
        return returnData(true, "操作成功");
    }
}
