package com.xc.apex.nre.nrep8posdemo.utils;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;

import androidx.core.content.ContextCompat;

import java.util.Locale;

public class CommonUtils {

    public static final int REQUEST_CODE_QRCODE_PERMISSIONS = 1;

    public static boolean checkPermissionAndCamera(Context context) {
        int hasCameraPermission = ContextCompat.checkSelfPermission(context.getApplicationContext(),
                Manifest.permission.CAMERA);
        return hasCameraPermission == PackageManager.PERMISSION_GRANTED;
    }

    /**
     * 判断当前系统语言是否为中文
     *
     * @return 如果是中文返回 true，否则返回 false
     */
    public static boolean isSystemLanguageChinese(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        Locale locale;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            locale = configuration.getLocales().get(0);
        } else {
            locale = configuration.locale;
        }
        String language = locale.getLanguage();
        return "zh".equals(language);
    }
}
