package com.xc.apex.nre.nrep8posdemo.utils;

import android.content.Context;

import com.xc.apex.nre.nrep8posdemo.R;
import com.xc.apex.nre.nrep8posdemo.model.GoodsBean;

import java.util.ArrayList;
import java.util.List;

public class GoodsDataUtil {

    private ArrayList<GoodsBean> goodsListData;
    private static volatile GoodsDataUtil instance;

    public static GoodsDataUtil getInstance(Context context) {
        if (instance == null) {
            synchronized (GoodsDataUtil.class) {
                if (instance == null) {
                    instance = new GoodsDataUtil(context);
                }
            }
        }
        return instance;
    }

    private GoodsDataUtil(Context context) {
        goodsListData = new ArrayList<>();
        goodsListData.add(new GoodsBean(1, context.getString(R.string.goods_cheeseburger), "5.99", R.drawable.ic_cheeseburger));
        goodsListData.add(new GoodsBean(2, context.getString(R.string.goods_double), "7.99", R.drawable.ic_double_cheeseburger));
        goodsListData.add(new GoodsBean(3, context.getString(R.string.goods_bacon), "8.99", R.drawable.ic_baconcheeseburger));
        goodsListData.add(new GoodsBean(4, context.getString(R.string.goods_tuna), "6.99", R.drawable.ic_tuna_sandwich));
        goodsListData.add(new GoodsBean(5, context.getString(R.string.goods_blt), "4.99", R.drawable.ic_blt_sandwich));
        goodsListData.add(new GoodsBean(6, context.getString(R.string.goods_sandwich), "5.19", R.drawable.ic_club_sandwich));
        goodsListData.add(new GoodsBean(7, context.getString(R.string.goods_salad), "3.99", R.drawable.ic_caesar_salad));
        goodsListData.add(new GoodsBean(8, context.getString(R.string.goods_chicken), "8.99", R.drawable.ic_fried_chicken));
        goodsListData.add(new GoodsBean(9, context.getString(R.string.goods_spaghetti), "8.99", R.drawable.ic_spaghetti_and_meatballs));
        goodsListData.add(new GoodsBean(10, context.getString(R.string.goods_steak), "10.99", R.drawable.ic_steak));
        goodsListData.add(new GoodsBean(11, context.getString(R.string.goods_hot_dog), "3.99", R.drawable.ic_chicago_style_hotdog));
        goodsListData.add(new GoodsBean(12, context.getString(R.string.goods_coca), "1.99", R.drawable.ic_coca_cola));
        goodsListData.add(new GoodsBean(13, context.getString(R.string.goods_juice), "1.99", R.drawable.ic_orange_juice));
        goodsListData.add(new GoodsBean(14, context.getString(R.string.goods_tea), "2.99", R.drawable.ic_iced_tea));
        goodsListData.add(new GoodsBean(15, context.getString(R.string.goods_coffee), "3.99", R.drawable.ic_iced_coffee));
    }

    public List<GoodsBean> getGoodsListData() {
        return goodsListData;
    }
}
