package com.xc.apex.nre.nrep8posdemo.utils;

import android.util.Log;

/**
 * 对象兼容类用于对象强转型保护
 */
public class Quantity {

    private final Object value;

    public Quantity(Object value) {
        this.value = value;
    }

    public int toInt() {
        if (value == null) {
            return 1;
        }

        Log.d("Quantity", "value type = " + value.getClass().getTypeName() + "data = "+ value);

        if (value instanceof Integer) {
            return (Integer) value;
        }

        if (value instanceof Long) {
            return ((Long) value).intValue();
        }

        if (value instanceof Double) {
            return ((Double) value).intValue();
        }

        if (value instanceof String) {
            try {
                return Integer.parseInt((String) value);
            } catch (NumberFormatException e) {
                e.getMessage();
                return 1;
            }
        }

        if (value instanceof QuantityProvider) {
            return ((QuantityProvider) value).getQuantity();
        }

        // 兜底
        return 1;
    }


    public interface QuantityProvider {
        int getQuantity();
    }

}
