package com.xc.apex.nre.nrep8posdemo.view;


import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;

import com.xc.apex.nre.nrep8posdemo.BaseApplicationV2;
import com.xc.apex.nre.nrep8posdemo.R;
import com.xc.apex.nre.nrep8posdemo.databinding.ActivityMainTabBinding;
import com.xc.apex.nre.nrep8posdemo.edgeos.EdgeOSService;
import com.xc.apex.nre.nrep8posdemo.utils.CommonUtils;
import com.xc.apex.nre.nrep8posdemo.utils.ToastUtil;
import com.xc.apex.nre.nrep8posdemo.view.base.BaseActivity;
import com.xc.apex.nre.nrep8posdemo.view.fragment.ChargeFragment;
import com.xc.apex.nre.nrep8posdemo.view.fragment.ItemsFragment;
import com.xc.apex.nre.nrep8posdemo.view.fragment.ReceiptsFragment;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SalesFragment;
import com.xc.apex.nre.nrep8posdemo.view.fragment.SettingsFragment;
import com.xc.apex.nre.nrep8posdemo.view.widget.CustomTabView;
import com.xc.apex.nre.nrep8posdemo.view.widget.VoiceWaveView;

import com.xctech.collaboration.core.TaskPriority;
import com.xctech.collaboration.sdk.CollaborationSDK;
import com.xctech.collaboration.core.TaskCallback;
import com.xctech.collaboration.core.TaskError;
import com.xctech.collaboration.core.TaskConfig;
import com.xctech.collaboration.core.CommandResult;

public class MainTabActivityV3 extends BaseActivity implements View.OnClickListener {
    private static final String TAG = "MainTabActivity";
    private static final int REQUEST_CODE_AUDIO_PERMISSION = 1001;

    private ActivityMainTabBinding binding;
    private SalesFragment salesFragment;
    private ReceiptsFragment receiptsFragment;
    private ItemsFragment itemsFragment;
    private SettingsFragment settingsFragment;
    private ChargeFragment chargeFragment;
    private Fragment currentFragment;

    // AI录音状态
    private boolean isRecording = false;
    private boolean isAnalyzing = false;
    private String transcript = "";

    // 声波动画View
    private VoiceWaveView voiceWaveView;

    // 脉冲动画
    private AnimatorSet pulseAnimator;

    private Handler mHandler = new Handler();

    // 当前任务ID（用于取消任务）
    private String currentTaskId;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_main_tab);
//        binding.setPresenter(this);

        // 初始化DataBinding变量
        binding.setIsRecording(false);
        binding.setIsAnalyzing(false);
        binding.setTranscript("");

        salesFragment = new SalesFragment();
        receiptsFragment = new ReceiptsFragment();
        itemsFragment = new ItemsFragment();
        settingsFragment = new SettingsFragment();

        binding.tabSales.setTabSelected();
        getSupportFragmentManager().beginTransaction().add(R.id.fragment_container, salesFragment).commit();
        currentFragment = salesFragment;

        // 初始化声波动画View
        initVoiceWaveView();
//
//        boolean hasCameraPermission = CommonUtils.checkPermissionAndCamera(MainTabActivity.this);
//        if (!hasCameraPermission) {
//            ActivityCompat.requestPermissions(MainTabActivity.this,
//                    new String[]{Manifest.permission.CAMERA},
//                    CommonUtils.REQUEST_CODE_QRCODE_PERMISSIONS);
//        }

        // 注册EdgeOS协同
        EdgeOSService.init(this, salesFragment);
    }

    private void initVoiceWaveView() {
        voiceWaveView = new VoiceWaveView(this);
        binding.voiceWaveContainer.addView(voiceWaveView);
    }

    @Override
    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.tab_sales) {
            switchTabFragment(binding.tabSales, salesFragment);
        } else if (viewId == R.id.tab_receipts) {
            switchTabFragment(binding.tabReceipts, receiptsFragment);
        } else if (viewId == R.id.tab_items) {
            switchTabFragment(binding.tabItems, itemsFragment);
        } else if (viewId == R.id.tab_setting) {
            switchTabFragment(binding.tabSetting, settingsFragment);
        }
    }

    /**
     * AI语音按钮点击事件
     */
    public void onAiVoiceClick(View view) {
        if (!isRecording && !isAnalyzing) {
            // 检查录音权限
            startRecording();
        } else if (isRecording) {
            stopRecording();
        }
    }

    /**
     * 开始录音
     */
    private void startRecording() {
        isRecording = true;
        isAnalyzing = false;
        transcript = "正在听，请说出您想点的菜...";

        updateBindingState();

        // 切换按钮样式为录音态（白色背景）
        binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_recording);

        // 按钮放大动画
        animateButtonScale(1.25f);

        // 显示遮罩层动画
        showMaskOverlay();

        // 开始脉冲动画
        startPulseAnimation();

        // 开始声波动画
        voiceWaveView.startAnimation();

        // TODO: 在这里调用实际的录音逻辑
        // startActualRecording();

        // 使用新的 SDK 触发 Michael Agent 模块
        sendCommandToMichael(BaseApplicationV2.Companion.getCOMMAND_START_MINCHALE());
    }

    /**
     * 停止录音并开始分析
     */
    private void stopRecording() {
        isRecording = false;
        isAnalyzing = true;
        transcript = "AI 正在分析订单...";

        updateBindingState();

        // 切换按钮样式为分析态（深色背景）
        binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_analyzing);

        // 按钮恢复正常大小
        animateButtonScale(1f);

        // 停止脉冲动画
        stopPulseAnimation();

        // 停止声波动画
        voiceWaveView.stopAnimation();

        // 隐藏遮罩层
        hideMaskOverlay();

        // 使用新的 SDK 触发 Michael Agent 模块停止命令
//        sendCommandToMichael(BaseApplicationV2.Companion.getCOMMAND_STOP_MINCHALE());
    }

    /**
     * 模拟AI分析过程
     */
    private void simulateAnalysis() {
        mHandler.postDelayed(() -> {
            isAnalyzing = false;
            transcript = "已为您添加：牛肉面、冰可乐";

            updateBindingState();

            // 恢复按钮默认样式
            binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_normal);

            // 显示气泡提示
            showBubbleTip(transcript);

            // 3秒后隐藏气泡
            mHandler.postDelayed(() -> {
                hideBubbleTip();
                transcript = "";
                binding.setTranscript("");
            }, 3000);

        }, 2000);
    }

    /**
     * 发送命令到 Michael Agent 模块
     */
    private void sendCommandToMichael(String commandText) {
        CollaborationSDK sdk = BaseApplicationV2.getCollaborationSDK();
        if (sdk == null) {
            Log.e(TAG, "SDK 未初始化");
            mHandler.post(() -> {
                ToastUtil.showToast(this, "SDK 未初始化");
            });
            return;
        }

        // 发送命令
        currentTaskId = sdk.command(
            commandText,
            new TaskConfig( 60_000L, false, 0, TaskPriority.NORMAL), // 60秒超时
            new TaskCallback<CommandResult>() {
                @Override
                public void onStart(String taskId) {
                    Log.d(TAG, "任务开始: " + taskId);
                    mHandler.post(() -> {
                        // 任务开始时的UI更新已在startRecording/stopRecording中处理
                    });
                }

                @Override
                public void onProgress(String taskId, CommandResult chunk) {
                    Log.d(TAG, "任务进度更新: " + taskId);
                    mHandler.post(() -> {
                        // 处理流式进度更新
                        if (chunk != null) {
                            String progressText = chunk.getData() != null ? chunk.getData() : chunk.getMessage();
                            if (progressText != null && !progressText.isEmpty()) {
                                transcript = progressText;
                                updateBindingState();
                            }
                        }
                    });
                }

                @Override
                public void onComplete(String taskId, CommandResult result) {
                    Log.d(TAG, "任务完成: " + taskId + ", 结果: " + result);
                    mHandler.post(() -> {
                        if (isAnalyzing) {
                            // 分析完成
                            isAnalyzing = false;
                            String resultText = null;
                            if (result != null) {
                                resultText = result.getData() != null ? result.getData() : result.getMessage();
                            }
                            
                            if (resultText != null && !resultText.isEmpty()) {
                                transcript = resultText;
                            } else {
                                transcript = "分析完成";
                            }
                            updateBindingState();

                            // 恢复按钮默认样式
                            binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_normal);

                            // 显示气泡提示
                            showBubbleTip(transcript);

                            // 3秒后隐藏气泡
                            mHandler.postDelayed(() -> {
                                hideBubbleTip();
                                transcript = "";
                                binding.setTranscript("");
                            }, 3000);
                        }
                    });
                }

                @Override
                public void onError(String taskId, TaskError error) {
                    Log.e(TAG, "任务错误: " + taskId + ", 错误: " + error.getMessage());
                    mHandler.post(() -> {
                        isRecording = false;
                        isAnalyzing = false;
                        transcript = "错误: " + error.getMessage();
                        updateBindingState();
                        binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_normal);
                        ToastUtil.showToast(MainTabActivityV3.this, "错误: " + error.getMessage());
                    });
                }

                @Override
                public void onTimeout(String taskId) {
                    Log.e(TAG, "任务超时: " + taskId);
                    mHandler.post(() -> {
                        isRecording = false;
                        isAnalyzing = false;
                        transcript = "请求超时，请重试";
                        updateBindingState();
                        binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_normal);
                        ToastUtil.showToast(MainTabActivityV3.this, "请求超时，请重试");
                    });
                }

                @Override
                public void onCancelled(String taskId) {
                    Log.d(TAG, "任务已取消: " + taskId);
                    mHandler.post(() -> {
                        isRecording = false;
                        isAnalyzing = false;
                        transcript = "已取消";
                        updateBindingState();
                        binding.layoutBtnContent.setBackgroundResource(R.drawable.bg_ai_button_normal);
                    });
                }
            }
        );
    }

    /**
     * 更新DataBinding状态
     */
    private void updateBindingState() {
        binding.setIsRecording(isRecording);
        binding.setIsAnalyzing(isAnalyzing);
        binding.setTranscript(transcript);
    }

    /**
     * 按钮缩放动画
     */
    private void animateButtonScale(float targetScale) {
        ObjectAnimator scaleX = ObjectAnimator.ofFloat(binding.btnAiVoice, "scaleX", targetScale);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat(binding.btnAiVoice, "scaleY", targetScale);

        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(scaleX, scaleY);
        animatorSet.setDuration(300);
        animatorSet.setInterpolator(new AccelerateDecelerateInterpolator());
        animatorSet.start();
    }

    /**
     * 显示遮罩层
     */
    private void showMaskOverlay() {
        binding.maskOverlay.setVisibility(View.VISIBLE);
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat(binding.maskOverlay, "alpha", 0f, 1f);
        fadeIn.setDuration(500);
        fadeIn.start();
    }

    /**
     * 隐藏遮罩层
     */
    private void hideMaskOverlay() {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat(binding.maskOverlay, "alpha", 1f, 0f);
        fadeOut.setDuration(300);
        fadeOut.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                binding.maskOverlay.setVisibility(View.GONE);
            }
        });
        fadeOut.start();
    }

    /**
     * 开始脉冲动画
     */
    private void startPulseAnimation() {
        binding.pulseRing.setVisibility(View.VISIBLE);
        binding.pulseRing.setAlpha(0.3f);

        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat("scaleX", 1f, 1.5f);
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat("scaleY", 1f, 1.5f);
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat("alpha", 0.3f, 0f);

        ObjectAnimator pulseAnim = ObjectAnimator.ofPropertyValuesHolder(
                binding.pulseRing, scaleX, scaleY, alpha);
        pulseAnim.setDuration(2000);
        pulseAnim.setRepeatCount(ValueAnimator.INFINITE);
        pulseAnim.setInterpolator(new LinearInterpolator());

        pulseAnimator = new AnimatorSet();
        pulseAnimator.play(pulseAnim);
        pulseAnimator.start();
    }

    /**
     * 停止脉冲动画
     */
    private void stopPulseAnimation() {
        if (pulseAnimator != null) {
            pulseAnimator.cancel();
        }
        binding.pulseRing.setVisibility(View.GONE);
    }

    /**
     * 显示气泡提示
     */
    private void showBubbleTip(String text) {
        binding.tvBubbleText.setText(text);
        binding.bubbleTip.setVisibility(View.VISIBLE);
        binding.bubbleTip.setAlpha(0f);
        binding.bubbleTip.setTranslationY(20f);

        ObjectAnimator fadeIn = ObjectAnimator.ofFloat(binding.bubbleTip, "alpha", 0f, 1f);
        ObjectAnimator slideUp = ObjectAnimator.ofFloat(binding.bubbleTip, "translationY", 20f, 0f);

        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(fadeIn, slideUp);
        animatorSet.setDuration(300);
        animatorSet.start();
    }

    /**
     * 隐藏气泡提示
     */
    private void hideBubbleTip() {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat(binding.bubbleTip, "alpha", 1f, 0f);
        fadeOut.setDuration(200);
        fadeOut.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                binding.bubbleTip.setVisibility(View.GONE);
            }
        });
        fadeOut.start();
    }

    private void switchTabFragment(CustomTabView view, Fragment fragment) {
        if (!view.isTabSelected()) {
            view.setTabSelected();
            switchFragment(fragment);
        }
    }

    public void switchFragment(Fragment fragment) {
        mHandler.post(() -> {
            if (currentFragment != fragment) {
                if (!fragment.isAdded()) {
                    getSupportFragmentManager().beginTransaction()
                            .add(R.id.fragment_container, fragment)
                            .hide(currentFragment)
                            .commit();
                } else {
                    getSupportFragmentManager().beginTransaction()
                            .hide(currentFragment)
                            .show(fragment)
                            .commit();
                }
                currentFragment = fragment;
            }
        });
    }

    public void showChargeFragment(Bundle args) {
        try {
            chargeFragment = new ChargeFragment();
            chargeFragment.setArguments(args);
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.fragment_container, chargeFragment)
                    .hide(currentFragment)
                    .commitAllowingStateLoss();
            currentFragment = chargeFragment;
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "showChargeFragment error:" + e.getMessage());
        }
    }

    public void hideChargeFragment() {
        try {
            getSupportFragmentManager().beginTransaction()
                    .hide(currentFragment)
                    .show(salesFragment)
                    .commitAllowingStateLoss();
            currentFragment = salesFragment;
            chargeFragment = null;
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "hideChargeFragment error:" + e.getMessage());
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (voiceWaveView != null) {
            voiceWaveView.stopAnimation();
        }
        if (pulseAnimator != null) {
            pulseAnimator.cancel();
        }
        mHandler.removeCallbacksAndMessages(null);
    }
}